<?php
/**
 * Partial template to display primary menu
 *
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * hook: news_express_before_primary_menu
 *
 * @since 1.0.0
 */
do_action( 'news_express_before_primary_menu' );

?>

<nav id="site-navigation" class="main-navigation" <?php news_express_schema_markup( 'site_navigation' ); ?>>
    <button class="news-express-menu-toogle" aria-controls="primary-menu" aria-expanded="false"> <?php esc_html_e( 'Menu', 'news-express' ); ?> </button>
    <div class="primary-menu-wrap">
        <?php
        wp_nav_menu(
            array(
                'theme_location' => 'primary_menu',
                'menu_id'        => 'primary-menu',
            )
        );
        ?>
    </div><!-- .primary-menu-wrap -->
</nav><!-- #site-navigation -->

<?php
/**
 * hook: news_express_after_primary_menu
 *
 * @since 1.0.0
 */
do_action( 'news_express_after_primary_menu' );