<?php
/**
 * Partial template to display top header date.
 *
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$news_express_header_date_enable = news_express_get_customizer_option_value( 'news_express_header_date_enable' );

if ( false === $news_express_header_date_enable ) {
    return;
}

$news_express_header_date_format = news_express_get_customizer_option_value( 'news_express_header_date_format' );

switch ( $news_express_header_date_format ) {
    case 'date_format_2':
        $date_format = 'l, d F, Y'; // Monday, 01 January, 2023
        break;

    default:
        $date_format = 'l, d M, Y'; // Monday, 01 Jan, 2023
        break;
}

$datetime = date_i18n( $date_format, current_datetime( 'timestamp' ) );
?>

<div class="header-date-wrap">
    <span class="date"><?php echo esc_html( $datetime ); ?></span>
</div><!-- .header-date-wrap -->
