<?php
/**
 * Partial template for main banner tabbed.
 * 
 * @package News Express
 */

//EXit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

$news_express_banner_tab_label_latest       = news_express_get_customizer_option_value( 'news_express_banner_tab_label_latest' );
$news_express_banner_tab_label_top_stories  = news_express_get_customizer_option_value( 'news_express_banner_tab_label_top_stories' );
$news_express_banner_tab_label_trending     = news_express_get_customizer_option_value( 'news_express_banner_tab_label_trending' );
            
?>

<div id="banner-tabbed" class="banner-tabbed-wrapper">
    <ul class="banner-tabs">
        <li><a href="#tab-latest"><i class='fas fa-clock' ></i><?php echo esc_html( $news_express_banner_tab_label_latest ); ?></a></li>
        <li><a href="#tab-top-stories"><i class='fas fa-fire' ></i><?php echo esc_html( $news_express_banner_tab_label_top_stories ); ?></a></li>
        <li><a href="#tab-trendng"><i class='fas fa-bolt' ></i><?php echo esc_html( $news_express_banner_tab_label_trending ); ?></a></li>
    </ul><!-- .banner-tab -->
    <div class="tabbed-content-wrapper">
        <div id="tab-latest" class="tab-content-wrap">
            <?php news_express_render_tab_posts( 'latest' ); ?>
        </div><!-- .tab-content-wrap -->
        <div id="tab-top-stories" class="tab-content-wrap" role="presentation">
            <?php news_express_render_tab_posts( 'top-stories' ); ?>
        </div><!-- .tab-content-wrap -->
        <div id="tab-trendng" class="tab-content-wrap">
            <?php news_express_render_tab_posts( 'trending' ); ?>
        </div><!-- .tab-content-wrap -->
    </div><!-- .tabbed-content-wrapper -->
</div><!-- .banner-tabbed-wrapper -->