<?php
/**
 * Partial template for banner slider layout.
 * 
 * @package News Express
 */

//EXit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

$slider_args = $args['slider_args'];
?>
<div class="slider-wrapper" data-auto="true">
    <?php
        $slider_query = new WP_Query( $slider_args );
        if ( $slider_query->have_posts() ) {
            while ( $slider_query->have_posts() ) {
                $slider_query->the_post();
                if ( has_post_thumbnail() ) {
                    $slide_img = 'has-image';
                } else {
                    $slide_img = 'no-image';
                }
    ?>
                <div class="single-slide-wrap <?php echo esc_attr( $slide_img ); ?>">
                    <div class="slide-content-wrap">                               
                        <div class="slide-title-wrap">
                            <h2 class="slide-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                        </div><!-- .slide-title-wrap -->
                        <div class="post-excerpt">
                            <?php echo esc_html( wp_trim_words( wp_strip_all_tags( get_the_excerpt() ) ) ); ?>
                        </div><!-- .post-excerpt -->

                        <div class="post-cats-meta-wrap news-express-flex">
                            <div class="post-cats-wrap">
                                <?php news_express_the_post_categories_list( get_the_ID(), 1 ); ?>
                            </div><!-- .post-cats-wrap -->                       
                            <div class="post-meta-wrap">
                                <?php news_express_posted_on(); ?>
                            </div><!-- .post-meta-wrap -->
                        </div><!-- .post-cats-meta-wrap-->                    
                    </div><!-- .slide-content-wrap -->

                    <div class="post-thumbnail-wrap">
                        <?php news_express_post_thumbnail( 'news-express-banner' ); ?>
                    </div> <!--post-thumbnail-wrap -->
                </div><!-- .single-slide-wrap -->
    <?php
            }
            wp_reset_postdata();
        }
        
    ?>
</div><!-- .slider-wrapper -->
