<?php
/**
 * Partial template for Main Banner Block
 * @package News Express
 */

//EXit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

$block_args = $args['block_args'];

?>
<div class="block-wrapper news-express-flex">
    <?php
        $block_query = new WP_Query( $block_args );
        if ( $block_query->have_posts() ) {
            while ( $block_query->have_posts() ) {
                $block_query->the_post();
                if ( has_post_thumbnail() ) {
                    $post_img = 'has-image';
                } else {
                    $post_img = 'no-image';
                }
    ?>
        <div class="single-block-post-wrapper <?php echo esc_attr( $post_img ); ?>">
            <div class="post-thumbnail-wrap">
                <?php news_express_post_thumbnail( 'news-express-block-medium' ); ?>
            </div>
            <div class="post-content-wrap">
                <div class="post-title-wrap">
                    <h2 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                </div> <!--.post-title-wrap-->
                <div class="post-cats-meta-wrap news-express-flex">
                    <div class="post-cats-wrap">
                        <?php news_express_the_post_categories_list( get_the_ID(), 1 ); ?>
                    </div><!--.post-cats-wrap-->
                    <div class="post-author-wrap">
                        <?php news_express_posted_by( get_the_ID(), 2 ); ?>
                    </div><!--.post-author-wrap-->
                    <div class="post-date-wrap">
                        <?php news_express_posted_on( get_the_ID(), 3 ); ?>
                    </div><!--.post-date-wrap-->
                </div> <!--.post-cats-meta-wrap -->
            </div><!--.post-content-wrap-->
        </div> <!-- .single-block-post-wrapper -->
    <?php
            }
            wp_reset_postdata();
        }
        
    ?>
</div><!--.block-wrapper-->
