<?php
/**
 * Template part for displaying a content located in top header.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * hook - news_express_before_header
 *
 * @since 1.0.0
 */
do_action( 'news_express_before_header' );
?>
<div id="header" class="header-wrapper">

		<div class="site-logo-wrapper ">
			<div class="news-express-container news-express-grid">
				<?php
					//primary menu
					get_template_part('template-parts/partials/header/top', 'menu');

					// site logo
					get_template_part('template-parts/partials/header/site', 'logo' );
					
					
					if ( true === news_express_get_customizer_option_value( 'news_express_header_social_enable' ) ) {
						get_template_part( 'template-parts/partials/header/social', 'icons' );
					}
				?>
	
			</div><!-- .news-express-container -->
		</div><!-- .site-logo-wrapper -->	


    	<div class="bottom-header-wrapper ">
			<div class="news-express-container news-express-flex">
            <?php
				// sticky sidebar toggle icon
				news_express_sticky_sidebar_toggle();

				// site mode switcher
				news_express_site_mode_switcher();

				//primary menu
          		get_template_part( 'template-parts/partials/header/primary', 'menu' );
				 
				// search icon
				get_template_part( 'template-parts/partials/header/search' );

				// custom button
				get_template_part( 'template-parts/partials/header/custom', 'button' );
			?>
    	</div><!-- .news-express-container -->
	</div><!-- .bottom-header-wrapper -->
</div><!-- header-wrapper -->

        
<?php
/**
 * hook - news_express_after_header
 *
 * @since 1.0.0
 */
do_action( 'news_express_after_header' );