<?php
/**
 * News Grid layout two
 * 
 * @package News Express
 */

//EXit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

extract( $args );

if ( isset( $post_options->blocklayout ) && ! empty( $post_options->blocklayout ) ) {
    $block_custom_classes[] = 'block-layout--'. esc_attr( $post_options->blocklayout );
}
?>

<section class="frontpage-block news-grid-block">
    <div class="news-express-container">
        <div class="block-wrapper <?php echo esc_attr( implode( ' ', $block_custom_classes ) ); ?>">
            
            <div class="block-wrapper-layout news-express-flex">
                <div class="block-wrapper-title-description">
                   <?php
                        if ( isset( $post_options->blockTitle ) && ! empty( $post_options->blockTitle ) ) {
                            echo '<h2 class="block-title">'. esc_html( $post_options->blockTitle ) .'</h2>';
                        }
                        if ( isset( $post_options->blockDescription ) && !empty( $post_options->blockDescription ) ) {
                            echo '<p class="block-description">'. esc_html( $post_options->blockDescription ) .'</p>';
                        } 
                    ?>
                </div><!--block-wrapper-title-description-->
                <div class="block-wrapper-button">
                    <?php
                        if ( isset( $post_options->blockLabel ) && !empty( $post_options->blockLabel ) ) {
                            echo '<a class="block-label-button" href="' . esc_url( $post_options->Url ) . '">';
                            echo esc_html( $post_options->blockLabel );
                            echo '</a>';
                        }
                    ?>
                </div><!--block-wrapper-button -->
            </div><!--block-wrapper-layout-->
            
            <div class="block-posts-wrapper">
                <?php
                    $grid_query = new WP_Query( $post_args );
                    $total_posts_count = $grid_query->post_count;
                    if ( $grid_query->have_posts() ) :
                        
                        while ( $grid_query->have_posts() ) :
                            $grid_query->the_post();
                            $current_post = $grid_query->current_post;
                            if ( has_post_thumbnail() ) {
                                $post_img = 'has-image';
                            } else {
                                $post_img = 'no-image';
                            }
                            if ( 0 === $current_post ) {
                                echo '<div class="block-main-wrapper">';
                            }

                            if ( 2 === $current_post ) {
                                echo '<div class="block-column-wrapper">';
                            }
                ?>
                            <article class="block-post-wrap <?php echo esc_attr( $post_img ); ?>">
                                
                                <div class="post-thumbnail-wrap">
                                    <?php news_express_post_thumbnail( 'news-express-block-medium' ); ?>
                                </div>
                                
                                <div class="post-content-wrap">
                                    <div class="post-title-wrap">
                                        <?php the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' ); ?>
                                    </div><!-- .post-title-wrap -->

                                    <div class="post-cats-meta-wrap news-express-flex">
                                        <?php if ( isset( $post_options->postCats ) && $post_options->postCats ) { ?>
                                            <div class="post-cats-wrap">
                                                <?php news_express_the_post_categories_list( get_the_ID(), 2 ); ?>
                                            </div><!-- .post-cats-wrap -->
                                        <?php } ?>

                                        <?php
                                            if ( isset( $post_options->postDate ) && $post_options->postDate ) {
                                                news_express_posted_on();
                                            }

                                            if ( isset( $post_options->postAuthor ) && $post_options->postAuthor ) {
                                                news_express_posted_by();
                                            }

                                            if ( isset( $post_options->postComment ) && $post_options->postComment ) {
                                                news_express_post_comment();
                                            }
                                        ?>
                                    </div><!-- .post-meta-wrap -->

                                    <?php
                                    if ( 0 === $current_post ) {
                                        $excerpt_length  = apply_filters( 'news_express_front_block_excerpt_length', 15 );
                                    ?>
                                        <div class="post-excerpt">
                                            <?php echo esc_html( wp_trim_words( wp_strip_all_tags( get_the_excerpt() ), $excerpt_length ) ); ?>
                                        </div><!-- .post-excerpt -->
                                    <?php
                                    }
                                    ?>
                                </div><!-- .post-content-wrap -->

                            </article><!-- .block-post-wrap -->
                <?php
                            if ( 1 === $current_post ) {
                                echo '</div><!-- .block-main-wrapper -->';
                            }
                            if ( $total_posts_count === $current_post + 1 && $total_posts_count > 1 ) {
                                echo '</div><!-- .block-column-wrapper -->';
                            }

                        endwhile;

                        wp_reset_postdata();

                    endif;
                ?>
            </div><!-- .block-posts-wrapper -->
        </div><!-- .block-wrapper -->
    </div> <!-- .news-express-container -->
</section><!-- .news-grid-block -->
