<?php
/**
 * News Carousel layout two
 * 
 * @package News Express
 */

//EXit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

extract( $args );

if ( isset( $post_options->blocklayout ) && ! empty( $post_options->blocklayout ) ) {
    $block_custom_classes[] = 'block-layout--'. esc_attr( $post_options->blocklayout );
}
?>

<section class="frontpage-block news-carousel-block">
    <div class="news-express-container">
        <div class="block-wrapper <?php echo esc_attr( implode( ' ', $block_custom_classes ) ); ?>">
            
            <div class="block-wrapper-layout news-express-flex">
                <div class="block-wrapper-title-description">
                   <?php
                        if ( isset( $post_options->blockTitle ) && ! empty( $post_options->blockTitle ) ) {
                            echo '<h2 class="block-title">'. esc_html( $post_options->blockTitle ) .'</h2>';
                        }
                        if ( isset( $post_options->blockDescription ) && !empty( $post_options->blockDescription ) ) {
                            echo '<p class="block-description">'. esc_html( $post_options->blockDescription ) .'</p>';
                        } 
                    ?>
                </div><!--block-wrapper-title-description-->
                <div class="block-wrapper-button">
                    <?php
                        if ( isset( $post_options->blockLabel ) && !empty( $post_options->blockLabel ) ) {
                            echo '<a class="block-label-button" href="' . esc_url( $post_options->Url ) . '">';
                            echo esc_html( $post_options->blockLabel );
                            echo '</a>';
                        }
                    ?>
                </div><!--block-wrapper-button -->
            </div><!--block-wrapper-layout-->
            
            <div class="block-posts-wrapper cS-hidden">
                <?php
                    $carousel_query = new WP_Query( $post_args );
                    if ( $carousel_query->have_posts() ) :
                        
                        while ( $carousel_query->have_posts() ) :
                            $carousel_query->the_post();
                            $post_img = has_post_thumbnail() ? 'has-image' : 'no-image';
                ?>
                            <article class="block-post-wrap <?php echo esc_attr( $post_img ); ?>">
                                
                                <div class="post-thumbnail-wrap">
                                    <?php news_express_post_thumbnail( 'news-express-block-medium' ); ?>
                                </div>
                                
                                <div class="post-content-wrap"> 
                                    <div class="post-title-wrap">
                                        <?php the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' ); ?>
                                    </div><!-- .post-title-wrap -->

                                    <div class="post-cats-meta-wrap news-express-flex">
                                        <div class="post-cats-wrap">
                                            <?php news_express_the_post_categories_list( get_the_ID(), 1 ); ?>
                                        </div><!-- .post-cats-wrap -->

                                        <div class="post-date-wrap">
                                            <?php news_express_posted_on( get_the_ID(), 3 ); ?>
                                        </div><!-- .post-date-wrap -->
                                    </div><!-- .post-cats-meta-wrap -->
                                </div><!-- .post-content-wrap -->
                            </article><!-- .block-post-wrap -->
                <?php
                        endwhile;

                        wp_reset_postdata(); 

                    endif;
                ?>
            </div><!-- .block-posts-wrapper -->
        </div><!-- .block-wrapper -->
    </div><!-- .news-express-container -->
</section><!-- .news-carousel-block -->
