<?php
/**
 * File to handle the main banner with dynamic design settings
 *
 * @package News Express
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

$enable_slider = news_express_get_customizer_option_value( 'news_express_banner_slider_enable' );
$enable_block  = news_express_get_customizer_option_value( 'news_express_banner_block_enable' );
$enable_tab    = news_express_get_customizer_option_value( 'news_express_banner_tab_enable' );

if ( ! $enable_slider && ! $enable_block && ! $enable_tab ) {
    return;
}

$news_express_banner_args = array(
    'slider_args' => array(
        'posts_per_page'      => 5,
        'orderby'             => 'date',
        'order'               => 'DESC',
        'ignore_sticky_posts' => true,
    ),
    'block_args' => array(
        'posts_per_page'      => 2,
        'orderby'             => 'date',
        'order'               => 'DESC',
        'ignore_sticky_posts' => true,
    ),
);

$slider_order = news_express_get_customizer_option_value( 'news_express_banner_slider_order_by' );
if ( $slider_order ) {
    $parts = explode( '-', $slider_order );
    $news_express_banner_args['slider_args']['orderby'] = esc_attr( $parts[0] ?? 'date' );
    $news_express_banner_args['slider_args']['order']   = esc_attr( $parts[1] ?? 'DESC' );
}

$slider_cat = news_express_get_customizer_option_value( 'news_express_banner_slider_category' );
if ( $slider_cat && $slider_cat !== 'all' ) {
    $news_express_banner_args['slider_args']['category_name'] = esc_attr( $slider_cat );
}

$slider_date_filter = news_express_get_customizer_option_value( 'news_express_banner_slider_date_filter' );
if ( $slider_date_filter && $slider_date_filter !== 'all' ) {
    $date_args = news_express_get_date_format_args( $slider_date_filter );
    $news_express_banner_args['slider_args']['date_query'] = $date_args;
}

$block_order = news_express_get_customizer_option_value( 'news_express_banner_block_order_by' );
if ( $block_order ) {
    $parts = explode( '-', $block_order );
    $news_express_banner_args['block_args']['orderby'] = esc_attr( $parts[0] ?? 'date' );
    $news_express_banner_args['block_args']['order']   = esc_attr( $parts[1] ?? 'DESC' );
}

$block_cat = news_express_get_customizer_option_value( 'news_express_banner_block_category' );
if ( $block_cat && $block_cat !== 'all' ) {
    $news_express_banner_args['block_args']['category_name'] = esc_attr( $block_cat );
}

$bg_type      = news_express_get_customizer_option_value( 'news_express_banner_bg_type' );
$bg_color     = news_express_get_customizer_option_value( 'news_express_banner_bg_color' );
$bg_image_id  = news_express_get_customizer_option_value( 'news_express_banner_bg_image' );
$bg_image_url = $bg_image_id ? wp_get_attachment_url( $bg_image_id ) : '';

$bg_style = '';
if ( $bg_type === 'bg-color' && $bg_color ) {
    $bg_style = 'background-color: ' . esc_attr( $bg_color ) . ';';
} elseif ( $bg_type === 'bg-image' && $bg_image_url ) {
    $bg_style = 'background-image: url( ' . esc_url( $bg_image_url ) . ' ); background-size: cover; background-position: center;';
}

$placement_parts = array();
if ( $enable_slider ) { $placement_parts[] = 'slider'; }
if ( $enable_block )  { $placement_parts[] = 'block'; }
if ( $enable_tab )    { $placement_parts[] = 'tab'; }

$dynamic_class = 'banner-placed--' . implode( '-', $placement_parts );

$news_express_banner_custom_classes = array(
    'has-banner-' . esc_attr( $bg_type ),
    esc_attr( $dynamic_class ),
);

echo '<div class="news-express-banner-wrapper ' . esc_attr( implode( ' ', $news_express_banner_custom_classes ) ) . '" style="' . esc_attr( $bg_style ) . '">';
echo '<div class="news-express-container news-express-flex">';
echo '<div class="news-express-slider-block">';

if ( $enable_slider ) {
    get_template_part( 'template-parts/partials/banner/slider', 'layout', $news_express_banner_args );
}

if ( $enable_block ) {
    get_template_part( 'template-parts/partials/banner/slider', 'block', $news_express_banner_args );
}

echo '</div><!-- .news-express-slider-block -->';

if ( $enable_tab ) {
    get_template_part( 'template-parts/partials/banner/slider', 'tab', $news_express_banner_args );
}

echo '</div><!-- .news-express-container -->';
echo '</div><!-- .news-express-banner-wrapper -->';
