<?php
/**
 * Template part for displaying a scroll top in footer.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$news_express_scroll_top_enable = news_express_get_customizer_option_value( 'news_express_scroll_top_enable' );

if ( false === $news_express_scroll_top_enable ) {
    return;
}

/**
 * hook - news_express_before_scroll_top
 * 
 * @since 1.0.0
 */
do_action( 'news_express_before_scroll_top' );

$news_express_scroll_top_arrow = news_express_get_customizer_option_value( 'news_express_scroll_top_arrow' );
?>
    <div id="news-express-scrollup">
        <i class="fas <?php echo esc_attr( $news_express_scroll_top_arrow ); ?>"></i>
    </div><!-- #news-express-scrollup -->
<?php
/**
 * hook - news_express_after_scroll_top
 * 
 * @since 1.0.0
 */
do_action( 'news_express_after_scroll_top' );