<?php 
/**
 * Template part for displaying a content located in bottom footer.
 *
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$news_express_footer_bottom_enable = news_express_get_customizer_option_value( 'news_express_footer_bottom_enable' );

if ( false === $news_express_footer_bottom_enable ) {
    return;
}
?>

<div class="site-info">
    <div class="news-express-container news-express-flex footer-bottom-wrapper">
        
        
        <div class="footer-left">
            <nav id="footer-navigation" class="footer-navigation" <?php news_express_schema_markup( 'site_navigation' ); ?>>
            <div class="footer-menu-wrap">
                <?php
                wp_nav_menu(
                    array(
                        'theme_location' => 'footer_menu',
                        'menu_id'        => 'footer-menu',
                    )
                );
                ?>
            </div><!-- .footer-menu-wrap -->
        </nav><!-- #site-navigation -->
        </div>

        <div class="footer-center">
            <span class="copyright-content">
                <?php
                $copyright_content = news_express_get_customizer_option_value( 'news_express_footer_copyright_info' );
                echo wp_kses_post( str_replace( '{year}', date('Y'), $copyright_content ) );
                ?>
            </span>
        </div>

        <div class="footer-right">
         <?php
         if ( true === news_express_get_customizer_option_value( 'news_express_footer_social_enable' ) ) {                     get_template_part( 'template-parts/partials/header/social', 'icons' );
     }
         ?>
        </div>

    </div>
</div><!-- .site-info -->
