<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News Express
 */

$custom_post_class = '';
if ( ! has_post_thumbnail()){
	$custom_post_class = 'no-thumbnail';
}

$news_express_archive_page_style = news_express_get_customizer_option_value('news_express_archive_page_style');

if ( 'archive-style--classic' === $news_express_archive_page_style ) {
	$thumb_size = 'full';
} else {
	$thumb_size = 'news-express-block-medium';
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $custom_post_class ); ?>>
	<div class="single-post-wrap">

		<div class="post-thumbnail-wrap">
			<?php
				news_express_post_thumbnail($thumb_size);
				news_express_the_estimated_reading_time();
			?>
		</div><!--post-thumbnail-wrap-->

	<div class="news-express-post-content-wrap">
		<header class="entry-header">
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta news-express-flex post-cats-meta-wrap">
				<div class="post-cats-wrap">
					<?php news_express_the_post_categories_list(get_the_ID(), 1); ?>
				</div><!-- .post-cats-wrap -->
				<?php
				news_express_posted_on();
				news_express_posted_by();
				news_express_entry_footer();
				?>
			</div><!-- .entry-meta post-cats-meta-wrap -->
		<?php endif; ?>
		</header><!-- .entry-header -->
		<?php
			get_template_part('template-parts/partials/post/content');
		?>
		<?php get_template_part( 'template-parts/partials/post/read', 'more' ); ?>
	</div> <!-- post-content-wrapper -->


</div> <!-- single-post-wrap  -->
</article><!-- #post-<?php the_ID(); ?> -->
