<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News Express
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php news_express_post_thumbnail(); ?>
	<header class="entry-header">
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
		<div class="entry-meta news-express-flex post-cats-meta-wrap">
			<?php if ( 'post' === get_post_type() ) : ?>
				<div class="post-cats-wrap">
						<?php news_express_the_post_categories_list(get_the_ID(), 1); ?>
				</div><!-- .post-cats-wrap -->
				
					<?php
					news_express_posted_on();
					news_express_posted_by();
					?>
					<?php news_express_entry_footer(); ?>
				
			<?php endif; ?>
		</div><!-- .post-cats-meta-wrap -->
	</header><!-- .entry-header -->

	<div class="entry-summary">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->

</article><!-- #post-<?php the_ID(); ?> -->
