<?php
/**
 * File to handle widget area and related hooks and functions.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'widgets_init', 'news_express_widgets_init' );

if ( ! function_exists( 'news_express_widgets_init' ) ) :

	 /**
	 * Register widget area.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
	 */
	function news_express_widgets_init() {

		register_sidebar(
			array(
				'name'          => esc_html__( 'Sidebar', 'news-express' ),
				'id'            => 'sidebar-1',
				'description'   => esc_html__( 'Add widgets here.', 'news-express' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__( 'Left Sidebar', 'news-express' ),
				'id'            => 'left-sidebar',
				'description'   => esc_html__( 'Add widgets here.', 'news-express' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__( 'Frontpage - Middle Right Sidebar', 'news-express' ),
				'id'            => 'front-middle-right-sidebar',
				'description' 	=> esc_html__( 'Add "NEWS EXPRESS: ABC" widget for frontpage middle right sidebar section.', 'news-express' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

		if ( true === news_express_get_customizer_option_value( 'news_express_header_sticky_sidebar_toggle_enable' ) ) {

			/**
			 * Register header sticky sidebar
			 *
			 * @since 1.0.0
			 */
			register_sidebar( array(
				'name'          => esc_html__( 'Header Sticky Sidebar', 'news-express' ),
				'id'            => 'header-sticky-sidebar',
				'description'   => esc_html__( 'Add widgets here.', 'news-express' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
	 			'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );

		}

		/**
		 * Register 4 different footer widget area 
		 *
		 * @since 1.0.0
		 */
		register_sidebars( 4 , array(
			'name'          => esc_html__( 'Footer Column %d', 'news-express' ),
			'id'            => 'footer-sidebar',
			'description'   => esc_html__( 'Added widgets are display at Footer Widget Area.', 'news-express' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );

    	// register widget NEWS EXPRESS: Latest Posts
    	register_widget( 'News_Express_Latest_Posts' );
    	register_widget('News_Express_Trending_Posts');
    	register_widget('News_Express_Author_Profile');    	
	}

endif;
require get_template_directory().'/inc/widgets/news-express-widgets-helper.php';
require get_template_directory().'/inc/widgets/latest-post.php';
require get_template_directory().'/inc/widgets/author-profile.php';
require get_template_directory().'/inc/widgets/trending-posts.php';