<?php
/**
 * Widget for display trending post
 * 
 * @package News Express
 */

//Exit if accesses directly
if (!defined('ABSPATH')){
    exit;
}

class News_Express_Trending_Posts extends WP_Widget{
    /**
     * Register widget with wordpress.
     */
    public function __construct(){
        $widget_ops = array(
            'classname'                     => 'news-express-widget News_Express_Trending_Posts',
            'description'                   => __('DISPLAY TRENDING POSTS IN VARIOUS LAYOUTS.', 'news-express'),
            'customize_selective_refresh'   => true,
        );
        parent::__construct('News_Express_Trending_Posts', __('NEWS EXPRESS: TRENDING Posts', 'news-express'), $widget_ops);
    }
    /**
     * Helper function that holds widget fields
     * Array is used in update and form functions
     */
    private function widget_fields() {
        
        $fields = array(
            'widget_title' => array(
                'widget_field_name'         => 'widget_title',
                'widget_field_title'        => __( 'Widget Title', 'news-express'),
                'widget_field_default'      => __('Trending Posts', 'news-express'),
                'widget_field_type'         => 'title',
                'widget_field_placeholder'  => __('Widget Title', 'news-express')
            ),
            'posts_query_filter'            => array(
                'widget_field_name'         =>'posts_date_filter',
                'widget_field_title'    => __( 'Posts date Filter', 'news-express'),
                'widget_field_default'  => 'trending',
                'widget_field_type'     => 'select',
                'widget_field_options'  => news_express_posts_date_filter_choices()
            ),
            'posts_count' => array(
                'widget_field_name'     => 'posts_count',
                'widget_field_title'    => __( 'No. of posts', 'news-express' ),
                'widget_field_default'  => 5,
                'widget_field_type'     => 'number',
                'input_attr'            => array(
                    'min'   => 1,
                    'max'   => 10,
                    'step'  => 1
                )
            ),
        );

        return $fields;

    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        extract( $args );
        if ( empty( $instance ) ) {
            return;
        }

        $widget_title = empty( $instance['widget_title'] ) ? '' : $instance['widget_title'];
        $posts_query_filter = empty( $instance['posts_query_filter'] ) ? 'trending' : $instance['posts_query_filter'];
        $posts_count = empty( $instance['posts_count'] ) ? 5 : $instance['posts_count'];

        $trending_args = array(
            'posts_per_page'        => absint( $posts_count ),
            'ignore_sticky_posts'   => true
        );

        if ( 'random' === $posts_query_filter ) {
            $trending_args['orderby'] = 'rand';
        }

        $trending_query = new WP_Query( $trending_args );

        $widget_custom_classes[] = 'trending-posts-wrapper';

        echo $before_widget;
        ?>

        <div class="news-express-aside <?php echo esc_attr( implode( ' ', $widget_custom_classes ) ); ?>">
            <?php
            if ( ! empty( $widget_title ) ) {
                echo $before_title . wp_kses_post( $widget_title ) . $after_title;
            }
            ?>
            <ul class="posts-wrapper trending-posts">
                <?php
                $total_posts_count = $trending_query->post_count;
                if ( $trending_query->have_posts() ) :

                    while ( $trending_query->have_posts() ) :
                        $trending_query->the_post();
                        $current_post = $trending_query->current_post;
                        if ( has_post_thumbnail() ) {
                            $post_img = 'has-image';
                        } else {
                            $post_img = 'no-image';
                        }

                        $thumb_size = ( $current_post === 0 ) ? 'news-express-block-medium' : 'thumbnail';
                ?>
                    <li class="post-wrap <?php echo esc_attr( $post_img ); ?>">
                        <?php if ( has_post_thumbnail() ) : ?>
                            <div class="post-thumbnail-wrap">
                                <?php news_express_post_thumbnail( $thumb_size ); ?>
                            </div><!-- .post-thumbnail-wrap -->
                        <?php endif; ?>

                        <div class="post-content-wrap">
                                    <div class="post-title-wrap">
                                        <?php the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' ); ?>
                                    </div><!-- .post-title-wrap -->
                                    <div class="post-cats-meta-wrap news-express-flex">
                                        <?php news_express_the_post_categories_list( get_the_ID(), 1 );?>
                                        <?php
                                         news_express_posted_by();?>
                                         </div><!-- .post-cats-meta-wrap -->
                                </div> <!-- post-content-wrap -->           
                    </li><!-- .post-wrap -->

                <?php

                wp_reset_postdata();
                    endwhile;

                endif;
                ?>
            </ul><!-- .posts-wrapper -->
        </div><!-- .news-express-aside -->
        <?php echo $after_widget;

    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param   array   $new_instance   Values just sent to be saved.
     * @param   array   $old_instance   Previously saved values from database.
     *
     * @uses    news_express_widget_updated_field_value()      defined in news-express-widgets-helper.php
     *
     * @return  array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            extract( $widget_field );

            // Use helper function to get updated field values
            $instance[$widget_field_name] = news_express_widget_updated_field_value($widget_field, $new_instance[$widget_field_name]);
            }
            return $instance;                      
        }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param   array $instance Previously saved values from database.
     *
     * @uses  news_express_show_widget_field() defined in news-express-widgets-helper.php
     */
    public function form( $instance ) {

        $widget_fields = $this->widget_fields();

        // Loop through fields
        foreach ( $widget_fields as $widget_field ) {

            // Make array elements available as variables
            extract( $widget_field );

            if ( empty( $instance ) && isset( $widget_field_default ) ) {
                $widget_field_value = $widget_field_default;
            } elseif ( empty( $instance ) ) {
                $widget_field_value = '';
            } else {
                $widget_field_value = $instance[$widget_field_name];
            }
            news_express_show_widget_field( $this, $widget_field, $widget_field_value );
        }
    }
} //end Class News_Express_Trending_Posts