<?php
/**
 * File to define functions and hooks related to preloader
 * 
 * @package News Express
 */

if ( ! function_exists( 'news_express_preloader_items' ) ) :

	/**
	 * function to manage the requested preloader items
	 * 
	 * @since 1.0.0
	 */
	function news_express_preloader_items() {
		$news_express_preloader_enable = news_express_get_customizer_option_value( 'news_express_preloader_enable' );

		if ( false === $news_express_preloader_enable ) {
			return;
		}

		$news_express_preloader_style = news_express_get_customizer_option_value( 'news_express_preloader_style' );

?>
		<div id="news-express-preloader" class="preloader-background">
			<div class="preloader-wrapper">
				<?php
					switch ( $news_express_preloader_style ) {
						case 'three_bounce':
				?>
							<div class="news-express-three-bounce">
	                            <div class="ne-child ne-bounce1"></div>
	                            <div class="ne-child ne-bounce2"></div>
	                            <div class="ne-child ne-bounce3"></div>
	                        </div>
				<?php
							break;

						case 'wave':
				?>
							<div class="news-express-wave">
	                            <div class="ne-rect ne-rect1"></div>
	                            <div class="ne-rect ne-rect2"></div>
	                            <div class="ne-rect ne-rect3"></div>
	                            <div class="ne-rect ne-rect4"></div>
	                            <div class="ne-rect ne-rect5"></div>
	                        </div>
				<?php
							break;

						case 'folding_cube':
				?>
							<div class="news-express-folding-cube">
	                            <div class="ne-cube1 ne-cube"></div>
	                            <div class="ne-cube2 ne-cube"></div>
	                            <div class="ne-cube4 ne-cube"></div>
	                            <div class="ne-cube3 ne-cube"></div>
	                        </div>
				<?php
							break;
						
						default:
				?>
							<div class="news-express-three-bounce">
	                            <div class="ne-child ne-bounce1"></div>
	                            <div class="ne-child ne-bounce2"></div>
	                            <div class="ne-child ne-bounce3"></div>
	                        </div>
				<?php
							break;
					}
				?>
			</div><!-- .preloader-wrapper -->
		</div><!-- #news-express-preloader -->
<?php
	}

endif;

add_action( 'news_express_before_page', 'news_express_preloader_items', 5 );