<?php
/**
 * Managed the theme's dynamic styles.
 *
 * @package News Express
 *
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/*---------------------- Custom CSS ----------------------------*/

    if ( ! function_exists( 'news_express_custom_css' ) ) :

        /**
         * function to handle news_express_head_css filter where all the css relation functions are hooked.
         *
         * @since 1.0.0
         */
        function news_express_custom_css( $output_css = NULL ) {

            // Add filter news_express_head_css for adding custom css via other functions.
            $output_css = apply_filters( 'news_express_head_css', $output_css );

            if ( ! empty( $output_css ) ) {
                $output_css = wp_strip_all_tags( news_express_minify_css( $output_css ) );
                echo "<!--News Express CSS -->\n<style type=\"text/css\">\n". $output_css ."\n</style>";
            }
        }

    endif;

    add_action( 'wp_head', 'news_express_custom_css', 9999 );

/*---------------------- General CSS ---------------------------*/

    if ( ! function_exists( 'news_express_general_css' ) ) :

        /**
         * function to handle the genral css for all sections.
         *
         * @since 1.0.0
         */
        function news_express_general_css( $output_css ) {
            $news_express_primary_theme_color = news_express_get_customizer_option_value('news_express_primary_theme_color');
            $news_express_text_color = news_express_get_customizer_option_value('news_express_text_color');
            $news_express_link_color = news_express_get_customizer_option_value('news_express_link_color');
            $news_express_link_hover_color = news_express_get_customizer_option_value('news_express_link_hover_color');
            $news_express_main_container_width = news_express_get_customizer_option_value('news_express_main_container_width');
            $news_express_boxed_container_width = news_express_get_customizer_option_value('news_express_boxed_container_width');

            $get_categories = get_categories( array( 'hide_empty' => 1 ) );
            //define variable for custom css
            $custom_css = '';

            // different categories color
            foreach ( $get_categories as $category ) {
                $get_term_id = $category->term_id;
                $get_cat_color = get_theme_mod( 'category_color_' . strtolower( $get_term_id ), '#3b2d1b' );

                // Background color for category label
                $custom_css .= ".post-cats-list .post-cat-item.cat-" . esc_attr( $get_term_id ) . " a:hover,.news-express-banner-wrapper .news-express-slider-block .post-cat-item.cat-" . esc_attr( $get_term_id ) . " a:hover, .news-middle-grid-block .block-layout--two .post-content-wrap .post-cat-item.cat-" . esc_attr( $get_term_id ) . " a:hover, .news-carousel-block .block-layout--two .post-content-wrap .post-cat-item.cat-" . esc_attr( $get_term_id ) . " a:hover { background-color: " . esc_attr( $get_cat_color ) . "; }\n";

                $custom_css .= ".post-cats-list .post-cat-item.cat-" . esc_attr( $get_term_id ) . " a:hover,.news-express-banner-wrapper .news-express-slider-block .post-cat-item.cat-" . esc_attr( $get_term_id ) . " a:hover, .news-middle-grid-block .block-layout--two .post-content-wrap .post-cat-item.cat-" . esc_attr( $get_term_id ) . " a:hover, .news-carousel-block .block-layout--two .post-content-wrap .post-cat-item.cat-" . esc_attr( $get_term_id ) . " a:hover { border-color: " . esc_attr( $get_cat_color ) . "; }\n";
            }
            
            //Color
            $custom_css .= "a:hover,a:focus,a:active,#site-navigation ul li:hover >a, #site-navigation ul li.current-menu-item >a, #site-navigation ul li.current_page_item >a, #site-navigation ul li.current-menu-ancestor >a, #site-navigation ul li.focus >a,.news-express-banner-wrapper .block-wrapper .post-title a:hover,.news-express-banner-wrapper .slide-content-wrap .slide-title a:hover, .news-express-banner-wrapper .news-express-slider-block a:hover, .news-express-banner-wrapper .news-express-slider-block span:hover, .post-title a:hover, .banner-tabbed-wrapper ul.banner-tabs li.ui-state-active a,#secondary .widget .widget-title, .block-title, .wp-block-heading, .widget-title, .related-post-title, .wp-block-search__label,.navigation .nav-links a.page-numbers:hover, .navigation .nav-links .page-numbers.current,.news-express-author-website a,.news-express-menu-toogle:hover,.edit-link a, .widget_tag_cloud .tagcloud a:hover,.widget.widget_tag_cloud a:hover, .news-middle-grid-block .block-layout--two .post-content-wrap a:hover, .news-carousel-block .block-layout--two .post-content-wrap a:hover, .site-title a:hover, .single-posts-layout--two .post-thumbnail-wrap .entry-meta span>a:hover{color:". esc_attr( $news_express_primary_theme_color)."}\n";
                  
            //Background color
            $custom_css .= ".header-search-wrapper .search-form-wrap .search-submit,.custom-button-wrap.news-express-icon-elements a,.news-ticker-label,#news-express-scrollup, .block-wrapper-button .block-label-button:hover, #site-navigation ul.sub-menu, #site-navigation ul.children,.site-footer,.news-express-folding-cube .ne-cube:before,.news-express-three-bounce .ne-child ,.news-express-wave .ne-rect, .news-express-slider-block .lSAction>a,.widget_search .search-submit,.header-search-wrapper .search-form-wrap .search-submit,.custom-button-wrap.news-express-icon-elements a,.news-ticker-label,button.wp-block-search__button, .read-more-button a:hover, .sticky-sidebar-close, .form-submit .submit:hover,.news-carousel-block .lSAction a:hover{background:". esc_attr ($news_express_primary_theme_color) .";}\n";

            //Responsive color             
            $custom_css .= "@media (max-width: 600px) {#site-navigation .primary-menu-wrap{background:". esc_attr ($news_express_primary_theme_color) .";}}\n";
            
            
            //border Color
            $custom_css .= " .widget_search .search-submit, .widget_tag_cloud .tagcloud a:hover,
            .widget.widget_tag_cloud a:hover{border-color:". esc_attr($news_express_primary_theme_color)."}\n";

             //border bottom Color
            $custom_css .= ".navigation .nav-links .page-numbers{border-bottom-color:". esc_attr($news_express_primary_theme_color)."}\n";

            //link color
            $custom_css .= ".entry-content a { color: " . esc_attr($news_express_link_color) . "; }\n";
           
            $custom_css .= ".header-news-ticker-wrapper .news-ticker-posts-wrapper .post-title a:hover,.banner-tabbed-wrapper ul.banner-tabs li a:hover,.entry-cat .cat-links a:hover, .entry-cat a:hover,.byline a:hover, .posted-on a:hover,.entry-meta span:hover::before, .byline:hover:before,.posted-on:hover:before,.edit-link a,.widget a:hover, .widget a:hover::before,.widget li:hover::before,.site-info .widget a:hover, .frontpage-block .entry-title a:hover, .slide-title a:hover, .trending-posts .entry-title a:hover, .latest-posts-wrapper .posts-column-wrapper .entry-title a:hover, .header-news-ticker-wrapper .post-title a:hover, .entry-title a:hover, .page-content a:hover,.entry-content a:hover, .entry-summary a:hover, .social-icons-wrapper a:hover {color: " . esc_attr($news_express_link_hover_color) . ";}\n";

            //frontpage banner bg type with value
            $news_express_banner_bg_type = news_express_get_customizer_option_value('news_express_banner_bg_type');
            if ('bg-image' === $news_express_banner_bg_type) {
                $banner_img_id = news_express_get_customizer_option_value('news_express_banner_bg_image');
                $banner_img_url = wp_get_attachment_image_url($banner_img_id, 'full');
                if ($banner_img_url) {
                    $custom_css .= ".news-express-banner-wrapper {
                        background-image: url('" . esc_url($banner_img_url) . "');
                    }\n";
                }
            } elseif ('bg-color' === $news_express_banner_bg_type) {
                $banner_bg_color = news_express_get_customizer_option_value('news_express_banner_bg_color');
                $custom_css .= ".news-express-banner-wrapper  {
                    background-color: " . esc_attr($banner_bg_color) . ";
                }\n";
            }
             $output_css .= $custom_css;
            return $output_css;
        }

    endif;

    add_filter( 'news_express_head_css', 'news_express_general_css' );

/*---------------------- Header CSS------------------------ ----*/

    if ( ! function_exists( 'news_express_main_header_css' ) ) :

        /**
         * function to handle the css for header section.
         *
         * @since 1.0.0
         */
        function news_express_main_header_css( $output_css ) {

            $news_express_header_main_bg_type = news_express_get_customizer_option_value( 'news_express_header_main_bg_type' );

            $custom_css = '';

            if ( 'bg-image' === $news_express_header_main_bg_type ) {
                $news_express_header_main_bg_image        = news_express_get_customizer_option_value( 'news_express_header_main_bg_image' );
                $news_express_header_main_bg_image_url    = wp_get_attachment_image_url( $news_express_header_main_bg_image, 'full' );
                if ( ! empty( $news_express_header_main_bg_image_url ) ) {
                    $custom_css .= "background-image:url(". esc_url( $news_express_header_main_bg_image_url ) .")\n";
                }
            } elseif ( 'bg-color' === $news_express_header_main_bg_type ) {
                $news_express_header_main_bg_color = news_express_get_customizer_option_value( 'news_express_header_main_bg_color' );
                $custom_css .= "background-color: ". esc_attr( $news_express_header_main_bg_color ) ."\n";
            }

            if ( ! empty( $custom_css ) ) {
                $output_css .= '/* Main Header CSS */#masthead{'. $custom_css .'}';
            }

            return $output_css;

        }

    endif;

    add_filter( 'news_express_head_css', 'news_express_main_header_css' );

/*---------------------- Typography CSS-------------------------*/

    if ( ! function_exists( 'news_express_typography_css' ) ) :

    /**
     * function to handle the typography css.
     *
     * @since 1.0.0
     */
    function news_express_typography_css( $output_css ) {

        $custom_css = '';

        /**
         * Body typography
         */
        $news_express_body_font_family       = news_express_get_customizer_option_value( 'news_express_body_font_family' );
        $news_express_body_font_weight       = news_express_get_customizer_option_value( 'news_express_body_font_weight' );
        $news_express_body_font_style        = news_express_get_customizer_option_value( 'news_express_body_font_style' );
        $news_express_body_font_transform    = news_express_get_customizer_option_value( 'news_express_body_font_transform' );
        $news_express_body_font_decoration   = news_express_get_customizer_option_value( 'news_express_body_font_decoration' );

        $custom_css .= "body{
            font-family:        $news_express_body_font_family;
            font-style:         $news_express_body_font_style;
            font-weight:        $news_express_body_font_weight;
            text-decoration:    $news_express_body_font_decoration;
            text-transform:     $news_express_body_font_transform;
        }\n";

        /**
         * H1 to H6 typography
         */
        $news_express_heading_font_family       = news_express_get_customizer_option_value( 'news_express_heading_font_family' );
        $news_express_heading_font_weight       = news_express_get_customizer_option_value( 'news_express_heading_font_weight' );
        $news_express_heading_font_style        = news_express_get_customizer_option_value( 'news_express_heading_font_style' );
        $news_express_heading_font_transform    = news_express_get_customizer_option_value( 'news_express_heading_font_transform' );
        $news_express_heading_font_decoration   = news_express_get_customizer_option_value( 'news_express_heading_font_decoration' );

        $custom_css .= "h1, h2, h3, h4, h5, h6 {
            font-family:        $news_express_heading_font_family;
            font-style:         $news_express_heading_font_style;
            font-weight:        $news_express_heading_font_weight;
            text-decoration:    $news_express_heading_font_decoration;
            text-transform:     $news_express_heading_font_transform;
        }\n";

        if ( ! empty( $custom_css ) ) {
            $output_css .= '/*/ Typography CSS /*/'. $custom_css;
        }

        return $output_css;
    }

endif;

add_filter( 'news_express_head_css', 'news_express_typography_css' );