<?php
/**
 * Single Posts and it's fields inside Innerpage Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
add_action( 'customize_register', 'news_express_register_single_posts_options' );

if( !function_exists( 'news_express_register_single_posts_options' ) ):
	/**
	 * Register theme options for Single Posts section.
	 * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
	function news_express_register_single_posts_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * Single Posts Section
         * 
         * Innerpage Settings > Single Posts
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize-> add_section( new News_Express_Customize_Section(
        	$wp_customize, 'news_express_section_post_single',
            	array(
            		'priority'	=> 15,
            		'panel'		=> 'news_express_panel_inner_page',
            		'title'		=> __( 'Single Posts', 'news-express' ),
            	)
            )
        );

        /**
         * Heading field for posts layout
         * 
         * Innerpage Settings > Single Posts
         * 
         * @since 1.0.0
         */
        $wp_customize-> add_setting( 'news_express_single_posts_layout_heading',
        	array(
        		'sanitize_callback'	=> 'sanitize_text_field'
        	)
        );
        $wp_customize-> add_control( new News_Express_Control_Heading (
        	$wp_customize, 'news_express_single_posts_layout_heading',
            	array(
            		'priority'	=> 15,
            		'section'	=> 'news_express_section_post_single',
            		'settings'	=> 'news_express_single_posts_layout_heading',
            		'label'	=> __( 'Posts Layout', 'news-express' )
                )
    		)
		);

        /**
         * Radio image field for single posts layout
         * 
         * Innerpage Settings > Single Posts
         * 
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_single_posts_layout',
        	array(
        		'default'	=> news_express_get_customizer_default( 'news_express_single_posts_layout' ),
        		'sanitize_callback'	=> 'news_express_sanitize_select',
        	)
    	);
    	$wp_customize-> add_control( new News_Express_Control_Radio_Image(
    		$wp_customize, 'news_express_single_posts_layout',
        		array(
        			'priority'	=> 15,
        			'section'	=> 'news_express_section_post_single',
        			'settings'	=> 'news_express_single_posts_layout',
        			'label'		=> __( 'Posts Layout', 'news-express' ),
        			'choices'	=> news_express_single_posts_layout_choices(),
        		)
        	)
        );

    	/**
    	 * Heading field for posts author box
    	 * Innerpage Settings > Single Posts
    	 * 
    	 * @since 1.0.0
    	 */
    	$wp_customize-> add_setting( 'single_posts_author_heading',
    		array(
    			'sanitize_callback'	=> 'sanitize_text_field'
    		)
    	);
    	$wp_customize-> add_control( new News_Express_Control_Heading(
    		$wp_customize, 'single_posts_author_heading',
        		array(
        			'priority'	=> 25,
        			'section'	=> 'news_express_section_post_single',
        			'settings'	=> 'single_posts_author_heading',
        			'label'	=> __( 'Author Box', 'news-express' )
        		)
        	)
        );

    	/**
    	 * Toggle option for single posts author box
    	 * 
    	 * Innerpage Settings > Single Posts
    	 * 
    	 * @since 1.0.0
    	 */
    	$wp_customize-> add_setting( 'news_express_single_posts_author_enable',
    		array(
    			'default'	=> news_express_get_customizer_default( 'news_express_single_posts_author_enable' ),
    			'sanitize_callback'	=> 'news_express_sanitize_checkbox'
    		)
    	);
    	$wp_customize-> add_control( new News_Express_Control_Toggle(
    		$wp_customize, 'news_express_single_posts_author_enable',
        		array(
        			'priority'	=> 25,
        			'section'	=> 'news_express_section_post_single',
        			'settings'	=> 'news_express_single_posts_author_enable',
        			'label'		=> __( 'Enable author box', 'news-express' )
        		)
        	)
        );

    	/**
    	 * Heading field for related posts
    	 * 
    	 * Innerpage Settings > Single Posts
    	 * 
    	 * @since 1.0.0
    	 */
    	$wp_customize-> add_setting( 'single_posts_related_heading',
    		array(
    			'sanitize_callback'	=> 'sanitize_text_field'
    		)
    	);
    	$wp_customize-> add_control( new News_Express_Control_Heading(
    		$wp_customize, 'single_posts_related_heading',
        		array(
        			'priority'	=> 45,
        			'section'	=> 'news_express_section_post_single',
        			'settings'	=> 'single_posts_related_heading',
        			'label'		=> __( 'Related Posts', 'news-express' )
        		)
        	)
        );
    	/**
    	 * Toggle option for single posts related posts
    	 * 
    	 * Innerpage Settings > Single Posts
    	 * 
    	 * @since 1.0.0
    	 */
    	$wp_customize -> add_setting('news_express_single_posts_related_enable',
    		array(
    			'default'	=> news_express_get_customizer_default( 'news_express_single_posts_related_enable' ),
    			'sanitize_callback'	=> 'news_express_sanitize_checkbox'
    		)
    	);
    	$wp_customize-> add_control( new News_Express_Control_Toggle(
    		$wp_customize, 'news_express_single_posts_related_enable',
                array(
        			'priority'	=> 45,
        			'section'	=> 'news_express_section_post_single',
        			'settings'	=> 'news_express_single_posts_ralated_enable',
        			'label'		=> __( 'Enable related posts', 'news-express' )
    			)
    		)
    	);

    	/**
    	 * Text field for related posts section title
    	 * 
    	 * Innerpage Settings  > Single Posts
    	 * 
    	 * @since 1.0.0
    	 */
    	$wp_customize-> add_setting( 'news_express_single_posts_related_label',
    		array(
    			'default'	=> news_express_get_customizer_default( 'news_express_single_posts_related_label' ),
    			'sanitize_callback'	=> 'sanitize_text_field'
    		)
        );
    	$wp_customize-> add_control( 'news_express_single_posts_related_label',
    		array(
    			'priority'	 => 50,
    			'section'	 => 'news_express_section_post_single',
    			'settings'	 => 'news_express_single_posts_related_label',
    			'label'	     => __( 'Section Title', 'news-express' ),
    			'type'	     => 'text',
    		)
    	);

        /**
         * Upgrade field for single posts
         * 
         * Innerpage Settings > Single Posts
         *
         * @since 1.0.0
         */ 
        $wp_customize->add_setting( 'news_express_upgrade_single_post',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Upgrade(
            $wp_customize, 'news_express_upgrade_single_post',
                array(
                    'priority'      => 100,
                    'section'       => 'news_express_section_post_single',
                    'settings'      => 'news_express_upgrade_single_post',
                    'label'         => __( 'More Features with News Express Pro', 'news-express' ),
                    'choices'       => news_express_upgrade_choices( 'news_express_single_post' )
                )
            )
        );
	}

endif;