<?php
/**
 * 404 Error and it's fields inside Innerpage Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_page_error_options' );

if ( ! function_exists( 'news_express_register_page_error_options' ) ) :

    /**
     * Register theme options for 404 Error section.
     * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_page_error_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * 404 Error Section
         * 
         * Innerpage Settings > 404 Error
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_page_error',
                array(
                    'priority'  => 35,
                    'panel'     => 'news_express_panel_inner_page',
                    'title'     => __( '404 Error', 'news-express' ),
                )
            )
        );

        /**
         * Toggle option for search form in 404 error page.
         *
         * Innerpage Settings > 404 Error
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_error_page_search_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_error_page_search_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_error_page_search_enable',
                array(
                    'priority'          => 10,
                    'section'           => 'news_express_section_page_error',
                    'settings'          => 'news_express_error_page_search_enable',
                    'label'             => __( 'Enable Search box', 'news-express' )
                )
            )
        );

        /**
         * Toggle option for homepage button.
         *
         * Innerpage Settings > 404 Error
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_error_page_button_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_error_page_button_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_error_page_button_enable',
                array(
                    'priority'          => 20,
                    'section'           => 'news_express_section_page_error',
                    'settings'          => 'news_express_error_page_button_enable',
                    'label'             => __( 'Enable homepage button', 'news-express' )
                )
            )
        );

        /**
         * Text field for homepage button label
         *
         * Innerpage Settings > 404 Error
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_error_page_button_label',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_error_page_button_label' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_error_page_button_label',
                array(
                    'priority'          => 25,
                    'section'           => 'news_express_section_page_error',
                    'settings'          => 'news_express_error_page_button_label',
                    'label'             => __( 'Button Label', 'news-express' ),
                    'type'              => 'text',
                    // Required Dependency
                    'required'          => array(
                        array(
                            'control'  => 'news_express_error_page_button_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )
                )
            )
        );

        /**
         * Upgrade field for error page
         * 
         * Innerpage Settings > 404 Error
         *
         * @since 1.0.0
         */ 
        $wp_customize->add_setting( 'upgrade_error_page',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Upgrade(
            $wp_customize, 'upgrade_error_page',
                array(
                    'priority'      => 100,
                    'section'       => 'news_express_section_page_error',
                    'settings'      => 'upgrade_error_page',
                    'label'         => __( 'More Features with News Express Pro', 'news-express' ),
                    'choices'       => news_express_upgrade_choices( 'news_express_error_page' )
                )
            )
        );

    }

endif;