<?php
/**
 * Archive page and its field inside InnerPage Settings
 * 
 * @package News Express
 */

//Exit if accessed directly
if ( !defined ( 'ABSPATH' ) ) {
	exit;
}

add_action( 'customize_register', 'news_express_register_archive_options' );

if ( !function_exists( 'news_express_register_archive_options' ) ):

	/**
	 * Register theme options for archive section
	 * 
	 * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
	 * @since 1.0.0
	 */

	function news_express_register_archive_options( $wp_customize ) {

		/*
		*Failsafe is safe
		*/

		if ( ! isset ( $wp_customize)){
			return;
		}

		/**
		 * Archive Section
		 * 
		 * InnerPage Settings > Archive Pages
		 * 
		 * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         * 
		 */
		$wp_customize-> add_section( new News_Express_Customize_Section(
			$wp_customize, 'news_express_section_page_archive',
				array(
					'priority'	=> 5,
					'panel'		=> 'news_express_panel_inner_page',
					'title'		=> __( 'Archive Pages', 'news-express' ),
				)
			)
		);

		/**
		 * Select option for archive page style
		 * 
		 * InnerPage Settings > Archive Pages
		 * 
		 * @since 1.0.0
		 */
		$wp_customize-> add_setting( 'news_express_archive_page_style',
			array(
				'default'	=> news_express_get_customizer_default('news_express_archive_page_style'),
				'sanitize_callback' => 'news_express_sanitize_select'
			)
		);
		$wp_customize->add_control( 'news_express_archive_page_style',
			array(
				'priortiy'	=> 10,
				'section'	=> 'news_express_section_page_archive',
				'settings'	=> 'news_express_archive_page_style',
				'label'		=> __('Archive Page Style', 'news-express'),
				'type'		=> 'select',
				'choices'	=>news_express_archive_page_style_choices()
			)
		);
		
		/**
		 * Toggle option for archive title prefix.
		 * 
		 * Innerpage Settings > Archive Pages
		 * 
		 * @since 1.0.0
		 */
		$wp_customize->add_setting( 'news_express_archive_title_prefix_enable',
		 	array(
		 		'default'	=> news_express_get_customizer_default( 'news_express_archive_title_prefix_enable'),
		 		'sanitize_callback'	=> 'news_express_sanitize_checkbox'
		 	)
		);
		$wp_customize->add_control( new News_Express_Control_Toggle(
			$wp_customize, 'news_express_archive_title_prefix_enable',
		 		array(
			 		'priority'	=> 15,
			 		'section'	=> 'news_express_section_page_archive',
			 		'settings'	=> 'news_express_archive_title_prefix_enable',
			 		'label'		=> __('Enable archive page title prefix.', 'news-express')
			 	)
			)
		);

		/**
         * Upgrade field for archive pages
         * 
         * Innerpage Settings > Archive Pages
         *
         * @since 1.0.0
         */ 
        $wp_customize->add_setting( 'news_express_upgrade_archive',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Upgrade(
            $wp_customize, 'news_express_upgrade_archive',
                array(
                    'priority'      => 100,
                    'section'       => 'news_express_section_page_archive',
                    'settings'      => 'news_express_upgrade_archive',
                    'label'         => __( 'More Features with News Express Pro', 'news-express' ),
                    'choices'       => news_express_upgrade_choices( 'news_express_archive' )
                )
            )
        );

	}

endif;