<?php
/**
 * Add news ticker inside header panel.
 * 
 * @package News Express
 */

//Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_ticker_options' );

if ( ! function_exists( 'news_express_register_ticker_options' ) ):

    /**
     * Register a theme options for News Ticker.
     * 
      * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_ticker_options( $wp_customize ) {

        /**
         * Failsafe is safe
         */
        if ( !isset( $wp_customize ) ) {
            return;
        }
         
        /**
         * Add News Ticker Section
         * 
         * Header Settings > News Ticker
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */ 
        $wp_customize-> add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_header_ticker',
                array(
                    'priority'  => 15, 
                    'panel'     =>  'news_express_panel_header',
                    'title'     => __( 'News Ticker', 'news-express' ),
                )
            )
        );

        /**
          * Toggle option for news ticker.
          * 
          * Header Settings > News Ticker
          * 
          * @since 1.0.0
          */
        $wp_customize-> add_setting( 'news_express_header_ticker_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_header_ticker_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle (
            $wp_customize, 'news_express_header_ticker_enable',
                array(
                    'priority'  => 15,
                    'section'   => 'news_express_section_header_ticker',
                    'settings'  => 'news_express_header_ticker_enable',
                    'label'     => __( 'Enable News Ticker', 'news-express' )
                )
            )
        );

        /**
          * Text field for news ticker label
          * 
          * Header Settings > News Ticker
          * 
          * @since 1.0.0
          */
        $wp_customize-> add_setting( 'news_express_header_ticker_label',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_header_ticker_label' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize-> add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_header_ticker_label',
                array(
                    'priority'  => 20,
                    'section'   => 'news_express_section_header_ticker',
                    'settings'  => 'news_express_header_ticker_label',
                    'label'     => __( 'Ticker Label', 'news-express' ),
                    'type'      => 'text',
                    // Required Dependency
                    'required'          => array(
                        array(
                            'control'  => 'news_express_header_ticker_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )
                )
            )
        );

        /**
          * Select option for ticker posts date filter
          * 
          * Header Settings > News Ticker
          * 
          * @since 1.0.0
          */
         $wp_customize-> add_setting( 'news_express_ticker_posts_date_filter',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_ticker_posts_date_filter' ),
                'sanitize_callback' => 'news_express_sanitize_select'
            )
        );
        $wp_customize-> add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_ticker_posts_date_filter',
                array(
                    'priority'  => 35,
                    'section'   => 'news_express_section_header_ticker',
                    'settings'  => 'news_express_ticker_posts_date_filter',
                    'label'     => __( 'Posts Date Filter', 'news-express' ),
                    'type'      => 'select',
                    'choices'   => news_express_posts_date_filter_choices(),
                    // Required Dependency
                    'required'          => array(
                        array(
                            'control'  => 'news_express_header_ticker_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )
                )
            )
        );

        /**
         * Upgrade field for ticker
         * 
         * Header Settings > News Ticker
         *
         * @since 1.0.0
         */ 
        $wp_customize->add_setting( 'upgrade_ticker',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Upgrade(
            $wp_customize, 'upgrade_ticker',
                array(
                    'priority'      => 70,
                    'section'       => 'news_express_section_header_ticker',
                    'settings'      => 'upgrade_ticker',
                    'label'         => __( 'More Features with News Express Pro', 'news-express' ),
                    'choices'       => news_express_upgrade_choices( 'news_express_ticker' )
                )
            )
        );

    }

endif;