<?php
/**
 * Add Main Area section and it's fields inside Header Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_area_options' );

if ( ! function_exists( 'news_express_register_area_options' ) ) :

    /**
     * Register theme options for Main Area section.
     * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_area_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /*---------------------------Main Area-----------------------------*/

        /**
         * Add Main Area Section
         * 
         * Header Settings > Main Area
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_header_main',
                array(
                    'priority'  => 10,
                    'panel'     => 'news_express_panel_header',
                    'title'     => __( 'Header Area', 'news-express' ),
                )
            )
        );

    
         /**
         * Toggle option for primary menu description
         *
         * Header Settings > Primary Menu
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_primary_menu_description_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_primary_menu_description_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_primary_menu_description_enable',
                array(
                    'priority'      => 5,
                    'section'       => 'news_express_section_header_main',
                    'settings'      => 'news_express_primary_menu_description_enable',
                    'label'         => __( 'Enable Menu Description', 'news-express' )
                )
            )
        );

         /**
         * Toggle option for primary menu sticky.
         *
         * Header Settings > Main Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_header_sticky_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_header_sticky_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_header_sticky_enable',
                array(
                    'priority'      => 10,
                    'section'       => 'news_express_section_header_main',
                    'settings'      => 'news_express_header_sticky_enable',
                    'label'         => __( 'Enable Header Sticky', 'news-express' )
                )
            )
        );
       
        /**
         * Toggle option for site mode switcher
         *
         * General Settings > Site Style
         *
         * @since 1.5.2
         */
        $wp_customize->add_setting( 'news_express_site_mode_switcher_option',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_site_mode_switcher_option' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_site_mode_switcher_option',
                array(
                    'priority'      => 15,
                    'section'       => 'news_express_section_header_main',
                    'settings'      => 'news_express_site_mode_switcher_option',
                    'label'         => __( 'Enable Site Mode Switcher', 'news-express' ),
                    'description'   => __( 'Enable/Disable option for site mode switcher.', 'news-express' )
                )
            )
        );


        /**
         * Toggle option for header search icon.
         *
         * Header Settings > Main Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_header_search_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_header_search_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_header_search_enable',
                array(
                    'priority'      => 20,
                    'section'       => 'news_express_section_header_main',
                    'settings'      => 'news_express_header_search_enable',
                    'label'         => __( 'Enable Search Icon', 'news-express' )
                )
            )
        );


        /**
         * Toggle option for header sticky sidebar toggle.
         *
         * Header Settings > Main Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_header_sticky_sidebar_toggle_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_header_sticky_sidebar_toggle_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_header_sticky_sidebar_toggle_enable',
                array(
                    'priority'      => 25,
                    'section'       => 'news_express_section_header_main',
                    'settings'      => 'news_express_header_sticky_sidebar_toggle_enable',
                    'label'         => __( 'Enable sticky sidebar toggle', 'news-express' )
                )
            )
        );
        
        
        /**
         * Heading field for custom button
         *
         * Header Settings > Main Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_header_custom_button_heading',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Heading(
            $wp_customize, 'news_express_header_custom_button_heading',
                array(
                    'priority'          => 30,
                    'section'           => 'news_express_section_header_main',
                    'settings'          => 'news_express_header_custom_button_heading',
                    'label'             => __( 'Custom Button', 'news-express' )
                )
            )
        );

        /**
         * Text field for custom button label
         *
         * Header Settings > Main Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_header_custom_button_label',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_header_custom_button_label' ),
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( 'news_express_header_custom_button_label',
            array(
                'priority'          => 35,
                'section'           => 'news_express_section_header_main',
                'settings'          => 'news_express_header_custom_button_label',
                'label'             => __( 'Custom Button Label', 'news-express' ),
                'type'              => 'text',
            )
        );

        /**
         * Url field for custom button link
         *
         * Header Settings > Main Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_header_custom_button_link',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_header_custom_button_link' ),
                'sanitize_callback' => 'esc_url_raw'
            )
        );
        $wp_customize->add_control( 'news_express_header_custom_button_link',
            array(
                'priority'          => 40,
                'section'           => 'news_express_section_header_main',
                'settings'          => 'news_express_header_custom_button_link',
                'label'             => __( 'Custom Button Link', 'news-express' ),
                'type'              => 'url',
            )
        );

        /**
         * Toggle option for Header header social icons.
         *
         * Header Settings > Header Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_header_social_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_header_social_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_header_social_enable',
                array(
                    'priority'          => 45,
                    'section'           => 'news_express_section_header_main',
                    'settings'          => 'news_express_header_social_enable',
                    'label'             => __( 'Enable Social Icons', 'news-express' ),
                )
            )
        );

        /**
         * Upgrade field for header main section
         * 
         * Header Settings > Main Area
         *
         * @since 1.0.0
         */ 
        $wp_customize->add_setting( 'news_express_upgrade_header_main',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Upgrade(
            $wp_customize, 'news_express_upgrade_header_main',
                array(
                    'priority'      => 70,
                    'section'       => 'news_express_section_header_main_area',
                    'settings'      => 'news_express_upgrade_header_main',
                    'label'         => __( 'More features with News Express Pro', 'news-express' ),
                    'choices'       => news_express_upgrade_choices( 'news_express_header_main' )
                )
            )
        );

    }

endif;