<?php
/**
 * Adds the Typography section and its fields to the General Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_typography_options' );

if ( ! function_exists( 'news_express_register_typography_options' ) ) :

    /**
     * Registers theme options for the Typography section.
     * 
     * @param WP_Customize_Manager $wp_customize Customizer object.
     * @since 1.0.0
     */
    function news_express_register_typography_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * Add Typography Section
         * 
         * General Settings > Typography
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_typography',
                array(
                    'priority'  => 30,
                    'panel'     => 'news_express_panel_general',
                    'title'     => __( 'Typography', 'news-express' ),
                )
            )
        );

        /**
         * Body Typography Section
         *
         * General Settings > Typography > Body
         *
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section(
            $wp_customize, 'news_express_section_typography_body',
                array(
                    'priority'      => 10,
                    'panel'         => 'news_express_panel_general',
                    'section'       => 'news_express_section_typography',
                    'title'         => __( 'Body', 'news-express' )
                )
            )
        );

        /**
         * Typography Font filed for body typography
         *
         * General Settings > Typography > Body
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting(
            'news_express_body_font_family',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_body_font_family' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_setting(
            'news_express_body_font_weight',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_body_font_weight' ),
                'sanitize_callback' => 'sanitize_key',
                'transport'         => 'postMessage'
            )
        );
        $wp_customize->add_setting(
            'news_express_body_font_style',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_body_font_style' ),
                'sanitize_callback' => 'sanitize_text_field',
                'transport'         => 'postMessage'
            )
        );
        $wp_customize->add_setting(
            'news_express_body_font_transform',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_body_font_transform' ),
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
                
            )
        );
        $wp_customize->add_setting(
            'news_express_body_font_decoration',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_body_font_decoration' ),
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
                
            )
        );

        $wp_customize->add_control( new News_Express_Control_Typography (
            $wp_customize,
                'body_typography',
                array(
                    'priority'      => 10,
                    'section'       => 'news_express_section_typography_body',
                    'settings'      => array(
                        'family'        => 'news_express_body_font_family',
                        'weight'        => 'news_express_body_font_weight',
                        'style'         => 'news_express_body_font_style',
                        'transform'     => 'news_express_body_font_transform',
                        'decoration'    => 'news_express_body_font_decoration'
                    ),
                    'description'   => __( 'Choose how you want the body font to appear.', 'news-express' ),
                    'l10n'          => array() // Pass custom labels. Use the setting key (above) for the specific label.
                )
            )
        );

        /**
         * Heading Typography Section
         *
         * General Settings > Typography > Heading
         *
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section(
            $wp_customize, 'news_express_section_typography_heading',
                array(
                    'priority'      => 20,
                    'panel'         => 'news_express_panel_general',
                    'section'       => 'news_express_section_typography',
                    'title'         => __( 'Heading', 'news-express' )
                )
            )
        );

        /**
         * Typography Font filed for heading typography
         *
         * General Settings > Typography > Heading
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting(
            'news_express_heading_font_family',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_heading_font_family' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_setting(
            'news_express_heading_font_weight',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_heading_font_weight' ),
                'sanitize_callback' => 'sanitize_key',
                'transport'         => 'postMessage'
            )
        );
        $wp_customize->add_setting(
            'news_express_heading_font_style',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_heading_font_style' ),
                'sanitize_callback' => 'sanitize_text_field',
                'transport'         => 'postMessage'
            )
        );
        $wp_customize->add_setting(
            'news_express_heading_font_transform',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_heading_font_transform' ),
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
                
            )
        );
        $wp_customize->add_setting(
            'news_express_heading_font_decoration',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_heading_font_decoration' ),
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
                
            )
        );

        $wp_customize->add_control( new News_Express_Control_Typography (
            $wp_customize,
                'heading_typography',
                array(
                    'priority'      => 10,
                    'section'       => 'news_express_section_typography_heading',
                    'settings'      => array(
                        'family'        => 'news_express_heading_font_family',
                        'weight'        => 'news_express_heading_font_weight',
                        'style'         => 'news_express_heading_font_style',
                        'transform'     => 'news_express_heading_font_transform',
                        'decoration'    => 'news_express_heading_font_decoration'
                    ),
                    'description'   => __( 'Choose how you want the header font to appear.', 'news-express' ),
                    'l10n'          => array() // Pass custom labels. Use the setting key (above) for the specific label.
                )
            )
        );

        /**
         * Upgrade field for typography section
         * 
         * General Settings > Typography
         *
         * @since 1.0.0
         */ 
        $wp_customize->add_setting( 'news_express_upgrade_typogrpahy',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Upgrade(
            $wp_customize, 'news_express_upgrade_typogrpahy',
                array(
                    'priority'      => 70,
                    'section'       => 'news_express_section_typography',
                    'settings'      => 'news_express_upgrade_typogrpahy',
                    'label'         => __( 'More Options with News Express Pro', 'news-express' ),
                    'choices'       => news_express_upgrade_choices( 'news_express_typography' )
                )
            )
        );

    }

endif;