<?php
/**
 * Add Social Icons section and it's fields inside General Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_social_icons_options' );

if ( ! function_exists( 'news_express_register_social_icons_options' ) ) :

    /**
     * Register theme options for Social Icons section.
     * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_social_icons_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * Add Social Icons Section
         * 
         * General Settings > Social Icons
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_social_icons',
                array(
                    'priority'  => 25,
                    'panel'     => 'news_express_panel_general',
                    'title'     => __( 'Social Icons', 'news-express' ),
                )
            )
        );

        /**
         * Toggle option for social icon target.
         *
         * General Settings > Social Icons
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_social_icon_link_target',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_social_icon_link_target' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_social_icon_link_target',
                array(
                    'priority'      => 10,
                    'section'       => 'news_express_section_social_icons',
                    'settings'      => 'news_express_social_icon_link_target',
                    'label'         => __( 'Open links in new tab', 'news-express' )
                )
            )
        );

        /**
         * Repeater field for Social Icons
         *
         * General Settings > Social Icons
         * 
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_social_icons', 
            array(
                'default'           => news_express_get_customizer_default( 'news_express_social_icons' ),
                'sanitize_callback' => 'news_express_sanitize_repeater'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Repeater(
            $wp_customize,  'news_express_social_icons',
                array(
                    'priority'        => 20,
                    'section'         => 'news_express_section_social_icons',
                    'settings'        => 'news_express_social_icons',
                    'label'           => __( 'Social Icons', 'news-express' ),
                    'news_express_box_label_text'       => __( 'Social Icons','news-express' ),
                    'news_express_box_add_control_text' => __( 'Add New Icon','news-express' ),
                    'news_express_field_limit'          => 4
                ),
                array(
                    'social_icon' => array(
                        'type'          => 'social_icon',   
                        'label'         => __( 'Social Icon', 'news-express' ),
                        'description'   => __( 'Choose social media icon.', 'news-express' )
                    ),
                    'social_url'  => array(
                        'type'          => 'url',
                        'label'         => __( 'Social Link URL', 'news-express' ),
                        'description'   => __( 'Enter social media url.', 'news-express' )
                    ),
                    'item_visible'   => array(
                        'type'  => 'hidden'
                    )
                )
            )
        );

        /**
         * Upgrade field for social icon section
         * 
         * General Settings > Social Icons
         *
         * @since 1.0.0
         */ 
        $wp_customize->add_setting( 'news_express_upgrade_social_icons',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Upgrade(
            $wp_customize, 'news_express_upgrade_social_icons',
                array(
                    'priority'      => 70,
                    'section'       => 'news_express_section_social_icons',
                    'settings'      => 'news_express_upgrade_social_icons',
                    'label'         => __( 'More features with News Express Pro', 'news-express' ),
                    'choices'       => news_express_upgrade_choices( 'news_express_social_icon' )
                )
            )
        );
    }

endif;