<?php
/**
 * Add Site Style section and it's fields inside General Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_site_style_options' );

if ( ! function_exists( 'news_express_register_site_style_options' ) ) :

    /**
     * Register theme options for Site Style section.
     * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_site_style_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * Add Site Style Section
         * 
         * General Settings > Site Style
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_site_style',
                array(
                    'priority'              => 10,
                    'panel'                 => 'news_express_panel_general',
                    'title'                 => __( 'Site Style', 'news-express' ),
                )
            )
        );

        /**
         * Radio image field for site layout
         *
         * General Settings > Site Style
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_site_container_layout',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_site_container_layout' ),
                'sanitize_callback' => 'news_express_sanitize_select',
            )
        );
        $wp_customize->add_control( new News_Express_Control_Radio_Image(
            $wp_customize, 'news_express_site_container_layout',
                array(
                    'priority'      => 10,
                    'section'       => 'news_express_section_site_style',
                    'settings'      => 'news_express_site_container_layout',
                    'label'         => __( 'Container Layout', 'news-express' ),
                    'choices'       => news_express_site_container_layout_choices(),
                )
            )
        );
    }

endif;