<?php
/**
 * Add Sidebar Layout section and it's fields inside General Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_sidebar_layout_options' );

if ( ! function_exists( 'news_express_register_sidebar_layout_options' ) ) :

    /**
     * Register theme options for Sidebar Layout section.
     * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_sidebar_layout_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * Add Sidebar Layout Section
         * 
         * General Settings > Sidebar Layout
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_sidebar_layout',
                array(
                    'priority'  => 40,
                    'panel'     => 'news_express_panel_general',
                    'title'     => __( 'Sidebar Layout', 'news-express' ),
                )
            )
        );

        /**
         * Toggle option for sidebar sticky
         *
         * General Settings > Sidebar Layout
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_sidebar_sticky_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_sidebar_sticky_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_sidebar_sticky_enable',
                array(
                    'priority'      => 5,
                    'section'       => 'news_express_section_sidebar_layout',
                    'settings'      => 'news_express_sidebar_sticky_enable',
                    'label'         => __( 'Enable Sidebar Sticky', 'news-express' )
                )
            )
        );

        
        /**
         * Heading field for Archive / Blog Sidebar Layout
         *
         * General Settings > Sidebar Layout
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'sidebar_archive_heading',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Heading(
            $wp_customize, 'sidebar_archive_heading',
                array(
                    'priority'      => 10,
                    'section'       => 'news_express_section_sidebar_layout',
                    'settings'      => 'sidebar_archive_heading',
                    'label'         => __( 'Archive/Blog Sidebar Layout', 'news-express' ),
                )
            )
        );

        /**
         * Radio image field for archive/blog sidebar
         *
         * General Settings > Sidebar Layout
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_archive_sidebar_layout',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_archive_sidebar_layout' ),
                'sanitize_callback' => 'news_express_sanitize_select',
            )
        );
        $wp_customize->add_control( new News_Express_Control_Radio_Image(
            $wp_customize, 'news_express_archive_sidebar_layout',
                array(
                    'priority'      => 15,
                    'section'       => 'news_express_section_sidebar_layout',
                    'settings'      => 'news_express_archive_sidebar_layout',
                    'choices'       => news_express_sidebar_layout_choices(),
                )
            )
        );

        /**
         * Heading field for Posts Sidebar Layout
         *
         * General Settings > Sidebar Layout
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'sidebar_posts_heading',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Heading(
            $wp_customize, 'sidebar_posts_heading',
                array(
                    'priority'      => 20,
                    'section'       => 'news_express_section_sidebar_layout',
                    'settings'      => 'sidebar_posts_heading',
                    'label'         => __( 'Posts Sidebar Layout', 'news-express' ),
                )
            )
        );

        /**
         * Radio image field for posts sidebar
         *
         * General Settings > Sidebar Layout
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_posts_sidebar_layout',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_posts_sidebar_layout' ),
                'sanitize_callback' => 'news_express_sanitize_select',
            )
        );
        $wp_customize->add_control( new News_Express_Control_Radio_Image(
            $wp_customize, 'news_express_posts_sidebar_layout',
                array(
                    'priority'      => 25,
                    'section'       => 'news_express_section_sidebar_layout',
                    'settings'      => 'news_express_posts_sidebar_layout',
                    'choices'       => news_express_sidebar_layout_choices(),
                )
            )
        );

        /**
         * Heading field for Pages Sidebar Layout
         *
         * General Settings > Sidebar Layout
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'sidebar_pages_heading',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Heading(
            $wp_customize, 'sidebar_pages_heading',
                array(
                    'priority'      => 30,
                    'section'       => 'news_express_section_sidebar_layout',
                    'settings'      => 'sidebar_pages_heading',
                    'label'         => __( 'Pages Sidebar Layout', 'news-express' ),
                )
            )
        );

        /**
         * Radio image field for posts sidebar
         *
         * General Settings > Sidebar Layout
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_pages_sidebar_layout',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_pages_sidebar_layout' ),
                'sanitize_callback' => 'news_express_sanitize_select',
            )
        );
        $wp_customize->add_control( new News_Express_Control_Radio_Image(
            $wp_customize, 'news_express_pages_sidebar_layout',
                array(
                    'priority'      => 35,
                    'section'       => 'news_express_section_sidebar_layout',
                    'settings'      => 'news_express_pages_sidebar_layout',
                    'choices'       => news_express_sidebar_layout_choices(),
                )
            )
        );


    }

endif;