<?php
/**
 * Add Scroll Top section and it's fields inside General Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_scroll_top_options' );

if ( ! function_exists( 'news_express_register_scroll_top_options' ) ) :

    /**
     * Register theme options for the Scroll Top section.
     * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_scroll_top_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * Add Scroll Top Section
         * 
         * General Settings > Scroll Top
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_scroll_top',
                array(
                    'priority'  => 50,
                    'panel'     => 'news_express_panel_general',
                    'title'     => __( 'Scroll Top', 'news-express' ),
                )
            )
        );

        /**
         * Toggle option for scroll top.
         *
         * General Settings > Scroll Top
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_scroll_top_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_scroll_top_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_scroll_top_enable',
                array(
                    'priority'      => 10,
                    'section'       => 'news_express_section_scroll_top',
                    'settings'      => 'news_express_scroll_top_enable',
                    'label'         => __( 'Enable Scroll Top', 'news-express' )
                )
            )
        );

        /**
         * Radio icons field for scroll top arrow
         *
         * General Settings > Scroll Top
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_scroll_top_arrow',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_scroll_top_arrow' ),
               'sanitize_callback' => 'sanitize_text_field',
            )
        );
        $wp_customize->add_control( new News_Express_Control_Radio_Icons(
            $wp_customize, 'news_express_scroll_top_arrow',
                array(
                    'priority'          => 20,
                    'section'           => 'news_express_section_scroll_top',
                    'settings'          => 'news_express_scroll_top_arrow',
                    'label'             => __( 'Arrow Icon', 'news-express' ),
                    'description'       => __( 'Choose required arrow from available lists.', 'news-express' ),
                    'choices'           => news_express_scroll_top_arrow_choices(),
                    // Required Dependency
                    'required'          => array(
                        array(
                            'control'  => 'news_express_scroll_top_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    ),
                )
            )
        );

        /**
         * Upgrade field for scroll top section
         * 
         * General Settings > Scroll Top
         *
         * @since 1.0.0
         */ 
        $wp_customize->add_setting( 'news_express_upgrade_scroll_top',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Upgrade(
            $wp_customize, 'news_express_upgrade_scroll_top',
                array(
                    'priority'      => 70,
                    'section'       => 'news_express_section_scroll_top',
                    'settings'      => 'news_express_upgrade_scroll_top',
                    'label'         => __( 'More features with News Express Pro', 'news-express' ),
                    'choices'       => news_express_upgrade_choices( 'news_express_scroll_top' )
                )
            )
        );

    }

endif;