<?php
/**
 * Add Preloader section and it's fields inside General Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_preloader_options' );

if ( ! function_exists( 'news_express_register_preloader_options' ) ) :

    /**
     * Register theme options for Preloader section.
     * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_preloader_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * Add Site Style Section
         * 
         * General Settings > Preloader
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_preloader',
                array(
                    'priority'              => 20,
                    'panel'                 => 'news_express_panel_general',
                    'title'                 => __( 'Preloader', 'news-express' ),
                )
            )
        );

        /**
         * Toggle option for preloader.
         *
         * General Settings > Preloader
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_preloader_enable',
            array(
                'default'           => news_express_get_customizer_default ( 'news_express_preloader_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_preloader_enable',
                array(
                    'priority'      => 10,
                    'section'       => 'news_express_section_preloader',
                    'settings'      => 'news_express_preloader_enable',
                    'label'         => __( 'Enable Preloader', 'news-express' )
                )
            )
        );

        /**
         * Radio image field for preloader styles
         *
         * General Settings > Preloader
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_preloader_style',
            array(
                'default'           => news_express_get_customizer_default ( 'news_express_preloader_style' ),
                'sanitize_callback' => 'news_express_sanitize_select',
            )
        );
        $wp_customize->add_control( new News_Express_Control_Radio_Image(
            $wp_customize, 'news_express_preloader_style',
                array(
                    'priority'          => 20,
                    'section'           => 'news_express_section_preloader',
                    'settings'          => 'news_express_preloader_style',
                    'label'             => __( 'Preloader Layout', 'news-express' ),
                    'choices'           => news_express_preloader_style_choices(),
                    'input_attrs'       => array(
                        'column'    => 4,
                    ),
                    // Required Dependency
                    'required'          => array(
                        array(
                            'control'  => 'news_express_preloader_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    ),
                )
            )
        );

        /**
         * Upgrade field for preloader section
         * 
         * General Settings > Preloader
         *
         * @since 1.0.0
         */ 
        $wp_customize->add_setting( 'news_express_upgrade_preloader',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Upgrade(
            $wp_customize, 'news_express_upgrade_preloader',
                array(
                    'priority'      => 70,
                    'section'       => 'news_express_section_preloader',
                    'settings'      => 'news_express_upgrade_preloader',
                    'label'         => __( 'More features with News Express Pro', 'news-express' ),
                    'choices'       => news_express_upgrade_choices( 'news_express_preloader' )
                )
            )
        );
    }

endif;