<?php
/**
 * Add Banner section and it's fields inside Frontpage Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_frontpage_banner_options' );

if ( ! function_exists( 'news_express_register_frontpage_banner_options' ) ) :

    /**
     * Register theme options for Banner section.
     * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_frontpage_banner_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * Add Banner Section
         * 
         * Frontpage Settings > Banner
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_frontpage_banner',
                array(
                    'priority'  => 5,
                    'panel'     => 'news_express_panel_front_page',
                    'title'     => __( 'Main Banner', 'news-express' ),
                )
            )
        );


        /**
         * Tabs field for Banner section
         *
         * Frontpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_frontpage_banner_tabs',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_frontpage_banner_tabs' ),
                'sanitize_callback' => 'sanitize_text_field',
            )
        );
        $wp_customize->add_control( new News_Express_Control_Tabs(
            $wp_customize, 'news_express_frontpage_banner_tabs',
                array(
                    'priority'      => 10,
                    'section'       => 'news_express_section_frontpage_banner',
                    'settings'      => 'news_express_frontpage_banner_tabs',
                    'choices'       => news_express_frontpage_banner_tabs_choices()
                )
            )
        );
             
        /**
         * Heading field for banner block settings
         *
         * Frontpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_block_heading',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Heading(
            $wp_customize, 'news_express_banner_block_heading',
                array(
                    'priority'          => 15,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_block_heading',
                    'label'             => __( 'Block Settings', 'news-express' ),
                )
            )
        );

        
        /**
          * Toggle option for block settings
          * 
          * Header Settings > Banner
          * 
          * @since 1.0.0
          */

        $wp_customize->add_setting( 'news_express_banner_block_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_block_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_banner_block_enable',
                array(
                    'priority'  => 20,
                    'section'   => 'news_express_section_frontpage_banner',
                    'settings'  => 'news_express_banner_block_enable',
                    'label'     => __( 'Enable Banner Block', 'news-express' )
                )
            )
        );

        /**
         * Select option of category for block posts
         *
         * Frongpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_block_category',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_block_category' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Dropdown_Categories(
            $wp_customize, 'news_express_banner_block_category',
                array(
                    'priority'          => 25,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_block_category',
                    'label'             => __( 'Block Category', 'news-express' ),
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_block_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );

        /**
         * Select option for block posts order by
         *
         * Frongpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_block_order_by',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_block_order_by' ),
                'sanitize_callback' => 'news_express_sanitize_select'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_banner_block_order_by',
                array(
                    'priority'          => 30,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_block_order_by',
                    'label'             => __( 'Posts Order By', 'news-express' ),
                    'type'              => 'select',
                    'choices'           => news_express_posts_order_by_choices(),
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_block_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );

        /**
         * Select option for slider posts date filter
         *
         * Frongpage Settings > Block
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_block_date_filter',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_block_date_filter' ),
                'sanitize_callback' => 'news_express_sanitize_select'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_banner_block_date_filter',
                array(
                    'priority'          => 35,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_block_date_filter',
                    'label'             => __( 'Posts Date Filter', 'news-express' ),
                    'type'              => 'select',
                    'choices'           => news_express_posts_date_filter_choices(),
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_block_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );
         
        /**
         * Heading field for banner slider settings
         *
         * Frontpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_slider_heading',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Heading(
            $wp_customize, 'news_express_banner_slider_heading',
                array(
                    'priority'          => 40,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_slider_heading',
                    'label'             => __( 'Slider Settings', 'news-express' ),
                )
            )
        );

        /**
          * Toggle option for banner
          * 
          * Header Settings > banner Slider
          * 
          * @since 1.0.0
          */
        $wp_customize-> add_setting( 'news_express_banner_slider_enable',
            array(
                'default'   => news_express_get_customizer_default( 'news_express_banner_slider_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_banner_slider_enable',
                array(
                    'priority'  => 45,
                    'section'   => 'news_express_section_frontpage_banner',
                    'settings'  => 'news_express_banner_slider_enable',
                    'label' => __( 'Enable Banner Slider', 'news-express' )
                )
            )
        );

        /**
         * Select option of category for slider posts
         *
         * Frongpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_slider_category',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_slider_category' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Dropdown_Categories(
            $wp_customize, 'news_express_banner_slider_category',
                array(
                    'priority'          => 50,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_slider_category',
                    'label'             => __( 'Slider Category', 'news-express' ),
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_slider_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );

        /**
         * Select option for slider posts order by
         *
         * Frongpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_slider_order_by',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_slider_order_by' ),
                'sanitize_callback' => 'news_express_sanitize_select'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_banner_slider_order_by',
                array(
                    'priority'          => 55,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_slider_order_by',
                    'label'             => __( 'Posts Order By', 'news-express' ),
                    'type'              => 'select',
                    'choices'           => news_express_posts_order_by_choices(),
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_slider_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );

        /**
         * Select option for slider posts date filter
         *
         * Frongpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_slider_date_filter',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_slider_date_filter' ),
                'sanitize_callback' => 'news_express_sanitize_select'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_banner_slider_date_filter',
                array(
                    'priority'          => 60,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_slider_date_filter',
                    'label'             => __( 'Posts Date Filter', 'news-express' ),
                    'type'              => 'select',
                    'choices'           => news_express_posts_date_filter_choices(),
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_slider_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );

        /**
         * Heading field for banner tab settings
         *
         * Frontpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_tab_heading',
            array(
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Heading(
            $wp_customize, 'news_express_banner_tab_heading',
                array(
                    'priority'          => 65,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_tab_heading',
                    'label'             => __( 'Tab Settings', 'news-express' ),
                )
            )
        );
        
        /**
          * Toggle option for news ticker.
          * 
          * Header Settings > News Ticker
          * 
          * @since 1.0.0
          */
        $wp_customize-> add_setting( 'news_express_banner_tab_enable',
            array(
                'default'   => news_express_get_customizer_default( 'news_express_banner_tab_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_banner_tab_enable',
                array(
                    'priority'  => 70,
                    'section'   => 'news_express_section_frontpage_banner',
                    'settings'  => 'news_express_banner_tab_enable',
                    'label' => __( 'Enable Banner Tabbed', 'news-express' )
                )
            )
        );

        /**
         * Number field for tabbed post count
         *
         * Frontpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_tab_post_count',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_tab_post_count' ),
                'sanitize_callback' => 'news_express_sanitize_number'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_banner_tab_post_count',
                array(
                    'priority'          => 75,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_tab_post_count',
                    'label'             => __( 'Post Count', 'news-express' ),
                    'type'              => 'number',
                    'input_attrs'       => array(
                        'max'   => 7
                    ),
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_tab_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );

        /**
         * Text field for latest tab label
         *
         * Frontpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_tab_label_latest',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_tab_label_latest' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_banner_tab_label_latest',
                array(
                    'priority'          => 75,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_tab_label_latest',
                    'label'             => __( 'Latest News', 'news-express' ),
                    'type'              => 'text',
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_tab_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );

        /**
         * Text field for top_stories tab label
         *
         * Frontpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_tab_label_top_stories',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_tab_label_top_stories' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_banner_tab_label_top_stories',
                array(
                    'priority'          => 80,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_tab_label_top_stories',
                    'label'             => __( 'Top Stories', 'news-express' ),
                    'description'       => __( 'Top stories posts will be listed by comment count.', 'news-express' ),
                    'type'              => 'text',
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_tab_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );

        /**
         * Text field for trending tab label
         *
         * Frontpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_tab_label_trending',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_tab_label_trending' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_banner_tab_label_trending',
                array(
                    'priority'          => 85,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_tab_label_trending',
                    'label'             => __( 'Trending News', 'news-express' ),
                    'type'              => 'text',
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_tab_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );

        /**
         * Select option of category for trending tab
         *
         * Frongpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_tab_trending_category',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_tab_trending_category' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Dropdown_Categories(
            $wp_customize, 'news_express_banner_tab_trending_category',
                array(
                    'priority'          => 90,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_tab_trending_category',
                    'label'             => __( 'Trending Category', 'news-express' ),
                    // Required Dependency
                    /*'required'          => array(
                        array(
                            'control'  => 'news_express_banner_tab_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    )*/
                )
            )
        );
       
        /**
         * Select option for banner background option
         *
         * Frongpage Settings > Banner
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_bg_type',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_bg_type' ),
                'sanitize_callback' => 'news_express_sanitize_select'
            )
        );
        $wp_customize->add_control( 'news_express_banner_bg_type',
            array(
                'priority'          => 95,
                'section'           => 'news_express_section_frontpage_banner',
                'settings'          => 'news_express_banner_bg_type',
                'label'             => __( 'Banner Background Type', 'news-express' ),
                'type'              => 'select',
                'choices'           => news_express_bg_type_choices()
            )
        );
        
        /**
         * Color Picker field for Footer Main Area background color
         * 
         * Footer Settings > Main Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_bg_color',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_bg_color' ),
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Color_Control(
            $wp_customize, 'news_express_banner_bg_color',
                array(
                    'priority'          => 100,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_bg_color',
                    'label'             => __( 'Background Color', 'news-express' ),
                    // Required Dependency
                    /*'required'        => array(
                        array(
                            'control'  => 'news_express_banner_bg_type',
                            'value'    => 'bg-color',
                            'operator' => '==',
                        )
                    )*/
                )
            )
        );

        /**
         * Cropped Image field for footer main area background image
         *
         * Footer Settings > Main Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_banner_bg_image',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_banner_bg_image' ),
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Cropped_Image_Control(
            $wp_customize, 'news_express_banner_bg_image',
                array(
                    'priority'          => 105,
                    'section'           => 'news_express_section_frontpage_banner',
                    'settings'          => 'news_express_banner_bg_image',
                    'label'             => __( 'Background Image', 'news-express' ),
                    'height'            => 270,
                    'width'             => 1320,
                    'flex_width'        =>true,
                    // Required Dependency
                    /*'required'        => array(
                        array(
                            'control'  => 'news_express_banner_bg_type',
                            'value'    => 'bg-image',
                            'operator' => '==',
                        )
                    )*/
                )
            )
        );

    }

endif;