<?php
/**
 * Add Bottom Fullwidth section and it's fields inside Frontpage Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_bottom_fullwidth_options' );

if ( ! function_exists( 'news_express_register_bottom_fullwidth_options' ) ) :

    /**
     * Register theme options for Bottom Fullwidth section.
     * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_bottom_fullwidth_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * Add Bottom Fullwidth Section
         * 
         * Frontpage Settings > Bottom Fullwidth
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_bottom_fullwidth',
                array(
                    'priority'  => 20,
                    'panel'     => 'news_express_panel_front_page',
                    'title'     => __( 'Bottom Fullwidth', 'news-express' ),
                )
            )
        );

        /**
         * Block Repeater field for Top Fullwidth
         *
         * Frontpage Settings > Top Fullwidth
         * 
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_front_bottom_fullwidth_blocks',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_front_bottom_fullwidth_blocks' ),
                'sanitize_callback' => 'sanitize_text_field'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Blocks_Repeater(
            $wp_customize, 'news_express_front_bottom_fullwidth_blocks',
                array(
                    'label'                     => esc_html__( 'Full Width Section Blocks', 'news-express' ),
                    'section'                   => 'news_express_section_bottom_fullwidth',
                    'settings'                  => 'news_express_front_bottom_fullwidth_blocks',
                    'priority'                  => 10,
                    'news_express_field_limit'  => 4
                )
            )
        );
        

    }

endif;