<?php
/**
 * Add Advertisement section and it's  fields inside Frontpage Settings Panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if (!defined('ABSPATH')){
	exit;
}

add_action('customize_register', 'news_express_register_ads_options');
    if(!function_exists('news_express_register_ads_options')):

	/**
	 * Register theme options for Advertisement section.
	 *
	 * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */ 

	function news_express_register_ads_options($wp_customize){
		/*
		* Failsafe is safe
		*/
		if(!isset($wp_customize)){
			return;
		}

		/**
		 * Add Advertisement Section 
		 * FrontPage Settings > Advertisement
		 * 
		 * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */

		$wp_customize-> add_section(new News_Express_Customize_Section(
			$wp_customize, 'news_express_section_ads',
			array(
				'priority'	=>30,
				'panel'		=> 'news_express_panel_front_page',
				'title'		=> __('Advertisement', 'news-express'),
			)
		)
	);

		/**
		 * Image field for ads
		 * 
		 * Frontpage Settings > Advertisement
		 * 
		 * @since 1.0.0
		 */

		  $wp_customize->add_setting('news_express_ads_image',
		  	array(
		  		'default'	=> news_express_get_customizer_default('news_express_ads_image'),
		  		'sanitize_callback'	=> 'absint'
		  	)
		);

		  $wp_customize-> add_control(new WP_Customize_Cropped_Image_Control(
		  	$wp_customize, 'news_express_ads_image',
		  	array(
		  		'priority'	=> 10,
		  		'section'	=> 'news_express_section_ads',
		  		'settings'	=> 'news_express_ads_image',
		  		'label'		=> __('Advertisement Image', 'news-express'),
		  		'height'	=> 90,
		  		'width'		=> 728,
		  		'flex_width'	=> true,
		  		'flex_height'	=> true,
		  	)
		  )
		);

		  /**
		   * Url field for ads link
		   * 
		   * FrontPage Settings > Advertisement
		   * 
		   * @since 1.0.0
		   */

		  $wp_customize-> add_setting('news_express_ads_image_link',
		  	array(
		  		'default'	=> news_express_get_customizer_default('news_express_ads_image_link'),
		  		'sanitize_callback'	=> 'esc_url_raw'
		  	)
		  );
		  $wp_customize-> add_control('news_express_ads_image_link',
		  	array(
		  		'priority'	=> 20,
		  		'section'	=> 'news_express_section_ads',
		  		'settings'	=> 'news_express_ads_image_link',
		  		'label'		=> __('Image Url', 'news-express'),
		  		'type'		=> 'url',
		  	)
		);
    }
endif;