<?php
/**
 * Footer main area fields in Footer Settings panel.
 * 
 * @package News Express
 */

//Exit if accessed directly

if (!defined('ABSPATH')){
    exit;
}

add_action('customize_register', 'news_express_register_footer_main_options');
if(!function_exists('news_express_register_footer_main_options')):

/**
 * Register theme options
 */
    function news_express_register_footer_main_options($wp_customize){
    /*
    Failsafe is safe
    */
    if(!isset($wp_customize))
    {
        return;
    }
        /**
         * Main Area Section
         * 
         * Footer Settings > Main Area
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */

        $wp_customize->add_section(new News_Express_Customize_Section(
            $wp_customize, 'news_express_section_footer_main',
            array(
                'priority'  => 10,
                'panel' => 'news_express_panel_footer',
                'title' => __('Main Area', 'news-express'),
            )
        )
    );
        /**
         * Toggle option for footer main area
         *
         * Footer Settings > Main Area
         *
         * @since 1.0.0
         */    

         $wp_customize->  add_setting('news_express_footer_main_enable',
            array(
                'default'       => news_express_get_customizer_default('news_express_footer_main_enable'),
                'sanitize_callback'     => 'news_express_sanitize_checkbox'
            )
        ); 

         $wp_customize-> add_control(new News_Express_Control_Toggle(
            $wp_customize, 'news_express_footer_main_enable',
            array(
                'priority'      => 15,
                'section'       => 'news_express_section_footer_main',
                'settings'      => 'news_express_footer_main_enable',
                'label'         => __('Enable footer main area.', 'news-express')
            )
        )
     ); 

        /**
         * Radio image field for footer widget area layout
         *
         * Footer Settings > Main Area
         *
         * @since 1.0.0
         */ 
         
         $wp_customize-> add_setting('news_express_footer_widget_area_layout',
            array(
                'default'   => news_express_get_customizer_default('news_express_footer_widget_area_layout'),
                'sanitize_callback' => 'news_express_sanitize_select',
            )
         );

         $wp_customize-> add_control(new News_Express_Control_Radio_Image(
            $wp_customize, 'news_express_footer_widget_area_layout',
            array(
                'priority'  => 20,
                'section'   => 'news_express_section_footer_main',
                'settings'  => 'news_express_footer_widget_area_layout',
                'label' => __('Widget Area Layout', 'news-express'),
                'choices'   => news_express_footer_widget_area_layout_choices(),
                // Required Dependency
                    'required'          => array(
                        array(
                            'control'  => 'news_express_footer_main_enable',
                            'value'    => true,
                            'operator' => '==',
                        ),
                    ),
             )
         )
     ); 
}

endif;