<?php
/**
 * Footer bottom area fields in Footer Settings panel.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_footer_bottom_options' );

if ( ! function_exists( 'news_express_register_footer_bottom_options' ) ) :

    /**
     * Register theme options for Bottom Area section.
     * 
     * @param WP_Customize_Manager $wp_customize Object that holds the customizer data.
     * @since 1.0.0
     */
    function news_express_register_footer_bottom_options( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }

        /**
         * Bottom Area Section
         * 
         * Footer Settings > Bottom Area
         * 
         * @uses $wp_customize->add_section() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_section/
         * @since 1.0.0
         */
        $wp_customize->add_section( new News_Express_Customize_Section (
            $wp_customize, 'news_express_section_footer_bottom',
                array(
                    'priority'  => 20,
                    'panel'     => 'news_express_panel_footer',
                    'title'     => __( 'Bottom Area', 'news-express' ),
                )
            )
        );

        /**
         * Toggle option for footer bottom area
         *
         * Footer Settings > Bottom Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_footer_bottom_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_footer_bottom_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_footer_bottom_enable',
                array(
                    'priority'          => 15,
                    'section'           => 'news_express_section_footer_bottom',
                    'settings'          => 'news_express_footer_bottom_enable',
                    'label'             => __( 'Enable footer bottom area.', 'news-express' )
                )
            )
        );


        /**
         * Textarea field for copyright content
         *
         * Footer Settings > Bottom Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_footer_copyright_info',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_footer_copyright_info' ),
                'transport'         => 'refresh',
                'sanitize_callback' => 'wp_kses_post'
            )
        );
        $wp_customize->add_control( new News_Express_Customize_Control (
            $wp_customize, 'news_express_footer_copyright_info',
                array(
                    'priority'          => 25,
                    'section'           => 'news_express_section_footer_bottom',
                    'settings'          => 'news_express_footer_copyright_info',
                    'label'             => __( 'Copyright Content', 'news-express' ),
                    'type'              => 'textarea',
                     // Required Dependency
                        'required'          => array(
                            array(
                                'control'  => 'news_express_footer_bottom_enable',
                                'value'    => true,
                                'operator' => '==',
                            ),
                        ),
                    )
                )
            );

        /**
         * Toggle option for Header header social icons.
         *
         * Header Settings > Header Area
         *
         * @since 1.0.0
         */
        $wp_customize->add_setting( 'news_express_footer_social_enable',
            array(
                'default'           => news_express_get_customizer_default( 'news_express_footer_social_enable' ),
                'sanitize_callback' => 'news_express_sanitize_checkbox'
            )
        );
        $wp_customize->add_control( new News_Express_Control_Toggle(
            $wp_customize, 'news_express_footer_social_enable',
                array(
                    'priority'          => 30,
                    'section'           => 'news_express_section_footer_bottom',
                    'settings'          => 'news_express_footer_social_enable',
                    'label'             => __( 'Enable Social Icons', 'news-express' ),
                     // Required Dependency
                        'required'          => array(
                            array(
                                'control'  => 'news_express_footer_bottom_enable',
                                'value'    => true,
                                'operator' => '==',
                            ),
                        ),
                )
            )
        );
    }

endif;