<?php
/**
 * Customizer: Add Panels/Sections
 *
 * Add Panels/Sections to the Customizer.
 * 
 * @package  News Express
 */ 

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'customize_register', 'news_express_register_customizer_panels_sections' );

if ( ! function_exists( 'news_express_register_customizer_panels_sections' ) ) :
    
    /**
     * Implement the Theme Customizer for Theme Settings.
     *
     * @param WP_Customize_Manager $wp_customize Theme Customizer object.
     */
    function news_express_register_customizer_panels_sections( $wp_customize ) {

        /*
         * Failsafe is safe
         */
        if ( ! isset( $wp_customize ) ) {
            return;
        }
    /*--------------------------- Add Panels -------------------------------------*/
        
        /**
         * Add Panel for General Settings
         * 
         * Customize > General Settings
         * 
         * @uses $wp_customize->add_panel() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_panel/
         * @since 1.0.0
         */
        $wp_customize->add_panel(
            'news_express_panel_general',
            array(
                'priority'          => 5,
                'title'             => __( 'General Settings', 'news-express' )
            )
        );

        /**
         * Add Panel for Header Settings
         * 
         * Customize > Header Settings
         * 
         * @uses $wp_customize->add_panel() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_panel/
         * @since 1.0.0
         */
        $wp_customize->add_panel(
            'news_express_panel_header',
            array(
                'priority'          => 10,
                'title'             => __( 'Header Settings', 'news-express' )
            )
        );

        /**
         * Add Panel for Front Page Settings
         * 
         * customize > Front Page Settings
         * 
         * @uses $wp_customize-> add_panel() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_panel/
         * @since 1.0.0
         */

        $wp_customize -> add_panel('news_express_panel_front_page',
            array(
                'priority'  => 20,
                'title'     => __('Front Page Settings', 'news-express')
            )
        );

        /**
         * Add Panel for Inner Page Settings
         * customize > Inner Page Settings
         * 
         * @uses $wp_customize-> add_panel() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_panel/
         * @since 1.0.0
         */

         $wp_customize -> add_panel('news_express_panel_inner_page',
            array(
                'priority'  => 25,
                'title' => __('Inner Page Settings', 'news-express')
            )
        ); 

        /**
         * Add Panel for Footer Settings
         * 
         * Customize > Footer Settings
         * 
         * @uses $wp_customize->add_panel() https://developer.wordpress.org/reference/classes/wp_customize_manager/add_panel/
         * @since 1.0.0
         */
        $wp_customize->add_panel(
            'news_express_panel_footer',
            array(
                'priority'          => 30,
                'title'             => __( 'Footer Settings', 'news-express' )
            )
        );

    }
    
endif;