<?php
/**
 * News Express Theme Customizer
 *
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function news_express_customize_register( $wp_customize ) {
	
	require get_template_directory(). '/inc/customizer/override-defaults.php';
	require get_template_directory(). '/inc/customizer/custom-controls/register-custom-controls.php';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'news_express_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'news_express_customize_partial_blogdescription',
			)
		);
	}

	/**
     * Register theme upsell sections.
     *
     * @since 1.0.0
     */
    $wp_customize->add_section( new News_Express_Upsell_Section(
        $wp_customize, 'theme_upsell',
            array(
                'title'     	=> __( 'News Express Pro', 'news-express' ),
                'button_text'  	=> __( 'Buy Now', 'news-express' ),
                'button_url'   	=> 'https://mysterythemes.com/pricing/?product_id=20881',
                'priority'  	=> 1,
            )
        )
    );
	
}

add_action( 'customize_register', 'news_express_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function news_express_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function news_express_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/*----------------------------- enqueue customizer scripts ------------------------------------------------*/

	if ( ! function_exists( 'news_express_customize_preview_js' ) ) {
		
		/**
		 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
		 */
		function news_express_customize_preview_js() {
		
			wp_enqueue_script( 'news-express-google-webfont', get_template_directory_uri() . '/inc/customizer/custom-controls/typography/webfontloader.js', array( 'jquery' ) );
			
				
		wp_enqueue_script( 'news-express-customizer', get_template_directory_uri() . '/inc/customizer/assets/js/customizer-preview.js', array( 'customize-preview' ), NEWS_EXPRESS_VERSION, true );
		}

	}

	add_action( 'customize_preview_init', 'news_express_customize_preview_js' );

	if ( ! function_exists( 'news_express_customize_backend_scripts' ) ) :

        /**
         * Enqueue required scripts/styles for customizer panel
         *
         * @since 1.0.0
         */
        function news_express_customize_backend_scripts() {
			
           wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/library/font-awesome/css/all.min.css', array(), '6.5.1' );
           
	       wp_enqueue_style( 'news-express-extend-customizer', get_template_directory_uri() . '/inc/customizer/assets/css/extend-customizer.css', array(), NEWS_EXPRESS_VERSION );

            wp_enqueue_style( 'news-express-custom-control-styles', get_template_directory_uri() . '/inc/customizer/assets/css/custom-control-styles.css', array(), NEWS_EXPRESS_VERSION );

            if ( function_exists( 'wp_enqueue_media' ) ) {
		        wp_enqueue_media();
		    }

            wp_enqueue_script( 'news-express-extend-customizer', get_template_directory_uri(). '/inc/customizer/assets/js/extend-customizer.js', array('jquery'), NEWS_EXPRESS_VERSION, true );

           wp_enqueue_script(
		        'news-express-control-dependency',
		        get_template_directory_uri() . '/inc/customizer/assets/js/control-dependency.js',
		        array( 'jquery', 'customize-controls' ),
		        '1.0.0',
		        true
		    );            

		    wp_enqueue_script( 'news-express-custom-control-scripts', get_template_directory_uri() . '/inc/customizer/assets/js/custom-control-scripts.js', array( 'jquery', 'customize-controls', 'customize-base' ), NEWS_EXPRESS_VERSION, true );
              }

    endif;

    add_action( 'customize_controls_enqueue_scripts', 'news_express_customize_backend_scripts', 10 );

/*----------------------------- load required files ------------------------------------------------*/
	
	require get_template_directory(). '/inc/customizer/extend-customizer/class-customize-panel.php';
	
	require get_template_directory(). '/inc/customizer/extend-customizer/class-customize-section.php';

	require get_template_directory(). '/inc/customizer/customizer-sanitize.php';
	
	require get_template_directory(). '/inc/customizer/customizer-helper.php';

	require get_template_directory(). '/inc/customizer/register-panels-sections.php';

$news_express_sections_array = array(
	'general' => array('sidebar', 'site-style', 'social-icons', 'preloader', 'scroll-top', 'typography', 'colors'),
	'header'  => array('header-main', 'news-ticker'),
    'front-page'  => array('top-section', 'middle-content', 'advertisement', 'bottom-fullwidth'),
    'innerpage'	=> array('archive', 'error', 'posts'),
	'footer'  => array(  'bottom-area', 'main-area' )
);

foreach ( $news_express_sections_array as $key => $value ) {
	foreach ( $value as $k => $v ) {
		require get_template_directory() . '/inc/customizer/sections/'. $key . '/' . $v .'.php';
	}
}