<?php
/**
 * Includes theme customizer defaults and starter functions.
 * 
 * @package  News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! function_exists( 'news_express_get_customizer_option_value' ) ) :

    /**
     * Get the customizer value `get_theme_mod()`
     * 
     * @since 1.0.0
     */
    function news_express_get_customizer_option_value( $setting_id ) {

        return get_theme_mod( $setting_id, news_express_get_customizer_default( $setting_id ) );

    }

endif;

if ( ! function_exists( 'news_express_get_customizer_default' ) ) :

    /**
     * Returns an array of the desired default News Express Options
     *
     * @return array
     */
    function news_express_get_customizer_default( $setting_id ) {

        $default_values = apply_filters( 'news_express_get_customizer_defaults',
            array(
                //container
                'news_express_site_container_layout'                 => 'separate',
                'news_express_main_container_width'                  => 1320,
                'news_express_boxed_container_width'                 => 1290,
                'news_express_site_mode'                             => 'light-mode',

                //preloader
                'news_express_preloader_enable'                      => true,
                'news_express_preloader_style'                       => 'wave',

                //advertisement
                'news_express_ads_image'                             => '',
                'news_express_ads_image_link'                        => '',
                      
                //colors
                'news_express_primary_theme_color'                   => '#0b7378',
                'news_express_text_color'                            => '#000000',
                'news_express_link_color'                            => '#000000',
                'news_express_link_hover_color'                      => '#0b7378',
                  
                //social icons
                'news_express_social_icon_link_target'               => false,
                'news_express_social_icons'                          => json_encode( array( array( 'social_icon' => 'fab fa-facebook', 'social_url'   => '', 'item_visible'   => 'show' ) ) ),
               
                //sidebar layout
                'news_express_sidebar_sticky_enable'                 => true,
                'news_express_archive_sidebar_layout'                => 'right-sidebar',
                'news_express_posts_sidebar_layout'                  => 'right-sidebar',
                'news_express_pages_sidebar_layout'                  => 'right-sidebar',

                //scroll top
                'news_express_scroll_top_enable'                     => true,
                'news_express_scroll_top_arrow'                      => 'fa-arrow-up',
                
                //typography 
                'news_express_body_font_family'                      => 'Roboto',
                'news_express_body_font_weight'                      => '400',
                'news_express_body_font_style'                       => 'normal',
                'news_express_body_font_transform'                   => 'inherit',
                'news_express_body_font_decoration'                  => 'inherit',
                'news_express_heading_font_family'                   => 'Nunito',
                'news_express_heading_font_weight'                   => '700',
                'news_express_heading_font_style'                    => 'normal',
                'news_express_heading_font_transform'                => 'inherit',
                'news_express_heading_font_decoration'               => 'inherit',
                
                //performance
                'news_express_site_schema_enable'                    => true,
                'news_express_posts_date_style'                      => 'publish',
                'news_express_posts_date_format'                     => 'default',
                'news_express_posts_thumbnail_hover_effect'          => 'hover-effect--one',
                'news_express_posts_reading_time_enable'             => true,
               
               //header area
                'news_express_header_date_enable'                    => true,
                'news_express_header_date_format'                    => 'date_format_1',
                'news_express_header_menu_enable'                    => true,
                'news_express_header_social_enable'                  => true,
                'news_express_top_menu_enable'                       => true,
                'news_express_header_area_tabs'                      => 'general',
                'news_express_header_sticky_enable'                  => true,
                'news_express_header_search_enable'                  => true,
                'news_express_site_mode_switcher_option'             => true,
                'news_express_dark_mode_option'                      => false,

                'news_express_header_sticky_sidebar_toggle_enable'   => true,
                'news_express_header_custom_button_label'            => __( 'Subscribe', 'news-express' ),
                'news_express_header_custom_button_link'             => '',
                'news_express_header_main_bg_type'                   => 'bg-none',
                'news_express_header_main_bg_color'                  => '#FF376C',
                'news_express_header_main_bg_image'                  => '',
                 //primary menu
                'news_express_primary_menu_description_enable'       => true,
               
                 //header ticker
                'news_express_header_ticker_enable'                  => true,
                'news_express_header_ticker_label'                   => __( 'Breaking News', 'news-express' ),
                'news_express_ticker_posts_date_filter'              => 'all',
                
                 //frontpage banner
                'news_express_frontpage_banner_tabs'                 => 'general',
                'news_express_frontpage_banner_layout'               => 'frontpage-banner-layout',
                'news_express_banner_slider_enable'                  => true,
                'news_express_banner_slider_order_by'                => 'date-desc',
                'news_express_banner_slider_category'                => 'all',
                'news_express_banner_slider_date_filter'             => 'all',
                'news_express_banner_block_enable'                   => true,
                'news_express_banner_block_category'                 => 'all',
                'news_express_banner_block_order_by'                 => 'date-desc',
                'news_express_banner_block_date_filter'              => 'all',
                'news_express_banner_tab_enable'                     => true,
                'news_express_banner_tab_post_count'                 => 4,
                'news_express_banner_tab_label_latest'               => __( 'Latest', 'news-express' ),
                'news_express_banner_tab_label_top_stories'          => __( 'Top Stories', 'news-express' ),
                'news_express_banner_tab_label_trending'             => __( 'Trending News', 'news-express' ),
                'news_express_banner_tab_trending_category'          => 'all',
                'news_express_banner_bg_type'                        => 'bg-none',
                'news_express_banner_bg_color'                       => '#F7F8F9',
                'news_express_banner_bg_image'                       => '',
                //homepage
                'news_express_frontpage_blocks_enable'               => true,
                // front middle content
                'news_express_front_middle_content_blocks'           => json_encode(
                    array(
                         array(
                            'type'                                   => 'news-featured',
                            'option'                                 => true,
                            'blockTitle'                             => __( 'Donot Miss', 'news-express' ),
                            'blockDescription'                       => __( '', 'news-express'),
                            'blockLabel'                             => __('See More', 'news-express'),
                            'Url'                                    => __('', 'news-express'),
                            'category'                               => 'all',
                            'postOrderby'                            => 'date-desc',
                            'postDatefilter'                         => 'all',
                            'postCount'                              => 6,
                            'blocklayout'                            => 'one',
                            'postCats'                               => true,
                            'postAuthor'                             => true,
                            'postDate'                               => true,
                         ),
                        array(
                            'type'                                   => 'news-middle-grid',
                            'option'                                 => true,
                            'blockTitle'                             => __( 'Latest Posts', 'news-express' ),
                            'blockDescription'                       => __( '', 'news-express'),
                            'blockLabel'                             => __('See More', 'news-express'),
                            'Url'                                    => __('', 'news-express'),
                            'category'                               => '',
                            'postOrderby'                            => 'date-desc',
                            'postDatefilter'                         => 'all',
                            'postCount'                              => 5,
                            'blocklayout'                            => 'one',
                            'postCats'                               => true,
                            'postAuthor'                             => true,
                         ),
                    )
                ),

                //front bottom fullwidth
                'news_express_front_bottom_fullwidth_blocks'         => json_encode(
                    array(
                         array(
                            'type'                                   => 'news-carousel',
                            'option'                                 => true,
                            'blockTitle'                             => __( 'Highlight', 'news-express' ),
                            'blockDescription'                       => __( '', 'news-express'),
                            'blockLabel'                             => __('See More', 'news-express'),
                            'Url'                                    => __('', 'news-express'),
                            'category'                               => 'all',
                            'postOrderby'                            => 'date-desc',
                            'postDatefilter'                         => 'all',
                            'postCount'                              => 6,
                            'blocklayout'                            => 'one',
                            ),
                         array(
                            'type'                                   => 'news-grid',
                            'option'                                 => true,
                            'blockTitle'                             => __( 'Popular News', 'news-express' ),
                            'blockDescription'                       => __( '', 'news-express'),
                            'blockLabel'                             => __('See More', 'news-express'),
                            'Url'                                    => __('', 'news-express'),                         
                            'category'                               => 'all',
                            'postOrderby'                            => 'date-desc',
                            'postDatefilter'                         => 'all',
                            'postCount'                              => 5,
                            'blocklayout'                            => 'one',
                            'postCats'                               => true,
                            'postAuthor'                             => true,
                        ),
                    )
                ),
                
               //archive page
                'news_express_archive_page_style'                    => 'archive-style--grid',
                'news_express_archive_title_prefix_enable'           => false,
                //404 error
                'news_express_error_page_search_enable'              => true,
                'news_express_error_page_button_enable'              => true,
                'news_express_error_page_button_label'               => __('Back To Home', 'news-express'),
                 //single posts
                'news_express_single_posts_layout'                   => 'posts-layout--one',
                'news_express_single_posts_author_enable'            => true,
                'news_express_single_posts_related_enable'           => true,
                'news_express_single_posts_related_label'            => __( 'Related Posts', 'news-express' ),
               
                //footer main area
                'news_express_footer_main_enable'                    => false,
                'news_express_footer_widget_area_layout'             => 'column-three',
               
                //footer bottom area
                'news_express_footer_social_enable'                  => true,
                'news_express_footer_bottom_enable'                  => true,
                'news_express_footer_copyright_info'                 => esc_html__( 'News Express &copy; {year}. All Rights Reserved.', 'news-express' )
            )
        );

        return  $default_values[$setting_id];

    }

endif;