                                        <?php
/**
 * Customizer helper where define functions related to customizer panel, sections and settings.
 * 
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/*---------------------------------- General Panel Choices ---------------------------------- --*/

    if ( ! function_exists( 'news_express_site_container_layout_choices' ) ) :

        /**
         * function to return choices of site container layout.
         *
         * @since 1.0.0
         */
        function news_express_site_container_layout_choices() {

            $site_container_layout = apply_filters( 'news_express_site_container_layout_choices',
                array(
                    'full-width'    => array(
                        'title'     => __( 'Full Width', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/full-width.png'
                    ),
                    'boxed'         => array(
                        'title'     => __( 'Boxed', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/boxed.png'
                    ),
                    'separate'         => array(
                        'title'     => __( 'Separate', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/seperate.png'
                    )
                )
            );

            return $site_container_layout;

        }

    endif;

    if ( ! function_exists( 'news_express_preloader_style_choices' ) ) :

        /**
         * function to return choices for preloader styles.
         *
         * @since 1.0.0
         */
        function news_express_preloader_style_choices() {

            $site_container_layout = apply_filters( 'news_express_preloader_style_choices',
                array(
                    'three_bounce'    => array(
                        'title'     => __( 'Three Bounce', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/three-bounce-preloader.gif'
                    ),
                    'wave'         => array(
                        'title'     => __( 'Wave', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/wave-preloader.gif'
                    ),
                    'folding_cube'         => array(
                        'title'     => __( 'Folding Cube', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/folding-cube-preloader.gif'
                    ),
                )
            );

            return $site_container_layout;

        }

    endif;

    if ( ! function_exists( 'news_express_sidebar_layout_choices' ) ) :

        /**
         * function to return choices for archive sidebar layouts.
         *
         * @since 1.0.0
         */
        function news_express_sidebar_layout_choices() {

            $sidebar_layouts = apply_filters( 'news_express_sidebar_layout_choices',
                array(
                    'right-sidebar'    => array(
                        'title'     => __( 'Right Sidebar', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/right-sidebar.png'
                    ),
                    'left-sidebar'  => array(
                        'title'     => __( 'Left Sidebar', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/left-sidebar.png'
                    ),
                    'both-sidebar'  => array(
                        'title'     => __( 'Both Sidebar', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/both-sidebar.png'
                    ),
                    'no-sidebar'  => array(
                        'title'     => __( 'No Sidebar', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/no-sidebar.png'
                    ),
                    'no-sidebar-center'  => array(
                        'title'     => __( 'No Sidebar Center', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/no-sidebar-center.png'
                    )
                )
            );

            return $sidebar_layouts;

        }

    endif;

    
    if ( ! function_exists( 'news_express_scroll_top_arrow_choices' ) ) :

        /**
         * function to return choices of scroll top arrow.
         *
         * @since 1.0.0
         */
        function news_express_scroll_top_arrow_choices() {

            $scroll_top_arrow = apply_filters( 'news_express_scroll_top_arrow_choices',
                array(
                    'fa-arrow-up'  => array(
                        'title' => __( 'Arrow 1', 'news-express' ),
                        'icon'  => 'fas fa-arrow-up'
                    ),
                    'fa-circle-up'  => array(
                        'title' => __( 'Arrow 2', 'news-express' ),
                        'icon'  => 'fas fa-circle-up'
                    ),
                    'fa-chevron-up'  => array(
                        'title' => __( 'Arrow 3', 'news-express' ),
                        'icon'  => 'fas fa-chevron-up'
                    ),
                )
            );

            return $scroll_top_arrow;

        }

    endif;

    if ( ! function_exists( 'news_express_site_mode_choices' ) ) :

        /**
         * function to return choices for site mode.
         *
         * @since 1.0.0
         */
        function news_express_site_mode_choices() {

            $site_mode_choices = apply_filters( 'news_express_site_mode_choices',
                array(
                    'light-mode'    => array(
                        'title' => __('Light', 'news-express'),
                        'icon'  => 'fas fa-toggle-on'
                    ),
                    'dark-mode'     => array(
                        'title' => __('Dark', 'news-express'),
                        'icon'  => 'fas fa-toggle-off'
                    ),
                )
            );

            return $site_mode_choices;

        }

    endif;

 if ( ! function_exists( 'news_express_posts_date_style_choices' ) ) :

        /**
         * function to return choices for posts date style
         *
         * @since 1.0.0
         */
        function news_express_posts_date_style_choices() {

            $posts_date_style_choices = apply_filters( 'news_express_posts_date_style_choices',
                array(
                    'publish'   => __( 'Published date', 'news-express' ),
                    'modify'    => __( 'Updated date', 'news-express' )
                )
            );

            return $posts_date_style_choices;

        }

    endif;

    if ( ! function_exists( 'news_express_posts_date_format_choices' ) ) :

        /**
         * function to return choices for posts date format
         *
         * @since 1.0.0
         */
        function news_express_posts_date_format_choices() {

            $posts_date_format_choices = apply_filters( 'news_express_posts_date_format_choices',
                array(
                    'default'       => __( 'Default by WordPress', 'news-express' ),
                    'format_one'    => __( 'Theme Format One', 'news-express' )
                )
            );

            return $posts_date_format_choices;

        }

    endif;

    if ( ! function_exists( 'news_express_posts_thumbnail_hover_effect_choices' ) ) :

        /**
         * function to return choices for posts thumbnail hover effect
         *
         * @since 1.0.0
         */
        function news_express_posts_thumbnail_hover_effect_choices() {

            $posts_thumb_effect_choices = apply_filters( 'news_express_posts_thumbnail_hover_effect_choices',
                array(
                    'none'              => __( 'None', 'news-express' ),
                    'hover-effect--one' => __( 'Hover Effect One', 'news-express' ),
                )
            );

            return $posts_thumb_effect_choices;

        }

    endif;


/*---------------------------------- Header Panel Choices --------------------------------------*/

    if ( ! function_exists( 'news_express_header_area_tabs_choices' ) ) :

        /**
         * function to return choices for header top area tab fields.
         *
         * @since 1.0.0
         */
        function news_express_header_area_tabs_choices() {

            $header_tab_fields = apply_filters( 'news_express_header_area_tabs_choices',
                array(
                    'general'   => array(
                        'title'     => __( 'General', 'news-express' ),
                        'fields'    => array(
                            'news_express_header_date_enable',
                            'news_express_header_date_format',
                            'news_express_header_menu_enable',
                            'news_express_header_social_enable',
                            'news_express_header_social_redirect'
                        )
                    ),
                    'design'    => array(
                        'title' => __( 'Design', 'news-express' ),
                        'fields'    => array(
                            'news_express_header_bg_color',
                        )
                    )
                )
            );

            return $header_tab_fields;

        }

    endif;

    if ( ! function_exists( 'news_express_header_date_format_choices' ) ) :

        /**
         * function to return choices for header top date format.
         *
         * @since 1.0.0
         */
        function news_express_header_date_format_choices() {

            $header_tab_fields = apply_filters( 'news_express_header_date_format_choices',
                array(
                    'date_format_1' => __( '01 Jan, 2023', 'news-express' ),
                    'date_format_2' => __( '01 January, 2023', 'news-express' ),
                )
            );

            return $header_tab_fields;

        }

    endif;

    if ( ! function_exists( 'news_express_header_main_area_tabs_choices' ) ) :

        /**
         * function to return choices for header main area tab fields.
         *
         * @since 1.0.0
         */
        function news_express_header_main_area_tabs_choices() {

            $header_main_tab_fields = apply_filters( 'news_express_header_main_area_tabs_choices',
                array(
                    'general'   => array(
                        'title'     => __( 'General', 'news-express' ),
                        'fields'    => array(
                            'news_express_header_sticky_enable',
                            'news_express_divider_main_area_one',
                            'news_express_header_search_enable',
                            'news_express_header_site_mode_switch_enable',
                            'news_express_header_sticky_sidebar_toggle_enable',
                            'news_express_header_sticky_sidebar_redirect',
                            'news_express_header_custom_button_heading',
                            'news_express_header_custom_button_label',
                            'news_express_header_custom_button_link',
                        )
                    ),
                    'design'    => array(
                        'title' => __( 'Design', 'news-express' ),
                        'fields'    => array(
                            'news_express_header_main_bg_type',
                            'news_express_header_main_bg_color',
                            'news_express_header_main_bg_image'
                        )
                    )
                )
            );

            return $header_main_tab_fields;

        }

    endif;

    if ( ! function_exists( 'news_express_bg_type_choices' ) ) :

        /**
         * function to return choices for background type.
         *
         * @since 1.0.0
         */
        function news_express_bg_type_choices() {

            $bg_types = apply_filters( 'news_express_bg_type_choices',
                array(
                    'bg-none'   => __( 'None', 'news-express' ),
                    'bg-color'  => __( 'Color', 'news-express' ),
                    'bg-image'  => __( 'Image', 'news-express' ),
                )
            );

            return $bg_types;

        }

    endif;
/*---------------------------------- Frontpage Panel Choices -----------------------------------*/
    if ( ! function_exists( 'news_express_frontpage_banner_tabs_choices' ) ) :
        /**
         * function to return choices for frontpage banner tab fields.
         *
         * @since 1.0.0
         */
        function news_express_frontpage_banner_tabs_choices() {
            $frontpage_banner_tab_fields = apply_filters( 'news_express_frontpage_banner_tabs_choices',
                array(
                    'general'   => array(
                        'title'     => __( 'General', 'news-express' ),
                        'fields'    => array(
                            'news_express_banner_slider_heading',
                            'news_express_banner_slider_enable',
                            'news_express_banner_slider_category',
                            'news_express_banner_slider_order_by',
                            'news_express_banner_slider_date_filter',
                            'news_express_banner_block_heading',
                            'news_express_banner_block_enable',
                            'news_express_banner_block_category',
                            'news_express_banner_block_order_by',
                            'news_express_banner_block_date_filter',
                            'news_express_banner_tab_heading',
                            'news_express_banner_tab_enable',
                            'news_express_banner_tab_post_count',
                            'news_express_banner_tab_label_latest',
                            'news_express_banner_tab_label_top_stories',
                            'news_express_banner_tab_label_trending',
                            'news_express_banner_tab_trending_category',
                        )
                    ),
                    'design'    => array(
                        'title' => __( 'Design', 'news-express' ),
                        'fields'    => array(
                            'news_express_banner_bg_type',
                            'news_express_banner_bg_color',
                            'news_express_banner_bg_image'
                        )
                    )
                )
            );
            return $frontpage_banner_tab_fields;
        }
    endif;
    if ( ! function_exists( 'news_express_posts_order_by_choices' ) ) :
        /**
         * function to return choices of posts order by.
         *
         * @since 1.0.0
         */
        function news_express_posts_order_by_choices() {
            $posts_order_by = apply_filters( 'news_express_posts_order_by_choices',
                array(
                    'date-desc'     => __( 'Newest - Oldest', 'news-express' ),
                    'date-asc'      => __( 'Oldest - Newest', 'news-express' ),
                    'title-asc'     => __( 'A - Z', 'news-express' ),
                    'title-desc'    => __( 'Z - A', 'news-express' ),
                    'rand-desc'     => __( 'Random', 'news-express' ),
                )
            );
            return $posts_order_by;
        }
    endif;
    if ( ! function_exists( 'news_express_posts_date_filter_choices' ) ) :
        /**
         * function to return choices of posts date filter.
         *
         * @since 1.0.0
         */
        function news_express_posts_date_filter_choices() {
            $posts_date_filter = apply_filters( 'news_express_posts_date_filter_choices',
                array(
                    'all'           => __( 'All', 'news-express' ),
                    'today'         => __( 'Today', 'news-express' ),
                    'this-week'     => __( 'This Week', 'news-express' ),
                    'last-week'     => __( 'Last Week', 'news-express' ),
                    'this-month'    => __( 'This Month', 'news-express' ),
                    'last-month'    => __( 'Last Month', 'news-express' )
                )
            );
            return $posts_date_filter;
        }
    endif;
    if ( ! function_exists( 'news_express_section_bg_type_choices' ) ) :
        /**
         * function to return choices of section background type.
         *
         * @since 1.0.0
         */
        function news_express_section_bg_type_choices() {
            $section_bg_type = apply_filters( 'news_express_section_bg_type_choices',
                array(
                    'color'   => __( 'Background Color', 'news-express' ),
                    'image'   => __( 'Background Image', 'news-express' )
                )
            );
            return $section_bg_type;
        }
    endif;
/*---------------------------------- Innerpage Panel Choices -------------------------------*/

if (!function_exists('news_express_archive_page_style_choices')):
    /**
     * function to return choices for archive page style.
     * Innerpage > Archive Settings
     * 
     * @since 1.0.0
     */
    function news_express_archive_page_style_choices() {
         $news_express_archive_page_style = apply_filters( 'news_express_archive_page_style_choices',
                array(
                    'archive-style--classic'  => __( 'Classic', 'news-express' ),
                    'archive-style--grid'     => __( 'Grid', 'news-express' ),
                    'archive-style--list'     => __( 'List', 'news-express' )
                )
            );

            return $news_express_archive_page_style;

        }

    endif;

        if ( ! function_exists( 'news_express_single_posts_layout_choices' ) ) :

        /**
         * function to return choices of single posts layout.
         *
         * @since 1.0.0
         */
        function news_express_single_posts_layout_choices() {

            $posts_layout = apply_filters( 'news_express_single_posts_layout_choices',
                array(
                    'posts-layout--one'  => array(
                        'title'     => __( 'Layout 1', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/single-layout-one.png'
                    ),
                    'posts-layout--two'  => array(
                        'title'     => __( 'Layout 2', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/single-layout-two.png'
                    )
                )
            );

            return $posts_layout;

        }

    endif;


/*---------------------------- Footer Panel Choices -----------------------------*/

    if ( ! function_exists( 'news_express_footer_widget_area_layout_choices' ) ) :

        /**
         * function to return choices of footer widget layout.
         *
         * @since 1.0.0
         */
        function news_express_footer_widget_area_layout_choices() {

            $posts_layout = apply_filters( 'news_express_footer_widget_area_layout_choices',
                array(
                    'column-one'  => array(
                        'title'     => __( 'Layout 1', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/footer-1.png'
                    ),
                    'column-two'  => array(
                        'title'     => __( 'Layout 2', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/footer-2.png'
                    ),
                    'column-three'  => array(
                        'title'     => __( 'Layout 3', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/footer-3.png'
                    ),
                    'column-four'  => array(
                        'title'     => __( 'Layout 4', 'news-express' ),
                        'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/footer-4.png'
                    )
                )
            );

            return $posts_layout;

        }

    endif;

/*---------------------------------- Upgrade Control Choices -----------------------------------*/
    
    if ( ! function_exists( 'news_express_upgrade_choices' ) ) :

        /**
         * Returns choices for the upgrade to pro.
         *
         * @since 1.0.0
         */
        function news_express_upgrade_choices( $setting_id ) {
            
            $upgrade_info_lists = array(
                'preloader'     => array( __( '15+ Styles', 'news-express' ), __( 'Device visibility', 'news-express' ) ),
                'social_icon'   => array( __( 'Add unlimited social icons field.', 'news-express' ), __( '2 different icon layout.', 'news-express' ), __( 'Custom icon size.', 'news-express' ), __( 'More icons with official color.', 'news-express' ) ),
                'typography'    => array( __( '950+ Google Fonts', 'news-express' ), __( 'Adjustable font size', 'news-express' ), __( 'Font Color Option', 'news-express' ) ),
                'scroll_top'    => array( __( '10+ Arrow Icons', 'news-express' ), __( 'Alignment Options', 'news-express' ), __( 'Device visibility', 'news-express' ), __( 'Color Option', 'news-express' ), __( 'Advance Design Option', 'news-express' ) ),
                'header_main'    => array( __( '3 more layouts', 'news-express' ), __( 'Device visibility for social icons', 'news-express' ), __( 'Live search option with different layout', 'news-express' ), __( 'Dynamic background options.', 'news-express' ) ),
                'ticker'    => array( __( '2 More Layouts', 'news-express' ), __( 'Color Options', 'news-express' ), __( 'Category Options', 'news-express' ) ),
                'front_featured'  => array( __( 'Add unlimited items.', 'news-express' ), __( '2 more layouts', 'news-express' ), __( 'Carousel setting option.', 'news-express' ) ),
                'front_stikcy'  => array( __( '2 more layouts', 'news-express' ) ),
                'archive' => array( __( '2 different post layout on each page style.', 'news-express' ), __( 'Two different Pagination Types', 'news-express' ), __( 'Adjustable excerpt length.', 'news-express' ), __( 'Post Element/Meta Re-Order.', 'news-express' ) ),
                'single_post' => array( __( '2 More Post Layouts', 'news-express' ),  __( '2 More author box layout', 'news-express' ),  __( 'Extra options for post navigation', 'news-express' ), __( '2 More Layout for related posts', 'news-express' ), __( 'Extra options for related posts section', 'news-express' ) ),
                'error_page' => array( __( '2 More Page Layouts', 'news-express' ), __( 'Blank Page Option', 'news-express' ),  __( 'Button Color', 'news-express' ) ),
            );

            $setting_id = explode( 'news_express_', $setting_id );
            $setting_id = $setting_id[1];

            return $upgrade_info_lists[$setting_id];

        }

    endif;