<?php
/**
 * Customizer Repeater Control.
 * 
 * @package News Express
*/

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! class_exists( 'News_Express_Control_Repeater' ) ) :
    
    /**
     * Repeater control
     *
     * @since 1.0.0
     */
    class News_Express_Control_Repeater extends WP_Customize_Control {

        /**
         * The control type.
         *
         * @access public
         * @var string
         * @since 1.0.0
         */
        public $type = 'news-express-repeater';

        /**
         * The repeater field label.
         *
         * @access public
         * @var string
         * @since 1.0.0
         */
        public $news_express_box_label = '';

        /**
         * The repeater field add button label.
         *
         * @access public
         * @var string
         * @since 1.0.0
         */
        public $news_express_box_add_control = '';

        /**
         * The repeater field limit count.
         *
         * @access public
         * @var int
         * @since 1.0.0
         */
        public $news_express_field_limit;

        /**
         * The fields that each container row will contain.
         *
         * @access public
         * @var array
         * @since 1.0.0
         */
        public $fields = array();

        /**
         * Get the listed categories.
         *
         * @access public
         * @var array
         * @since 1.0.0
         */
        public $categories = '';

        /**
         * Repeater drag and drop controller
         *
         * @since  1.0.0
         */
        public function __construct( $manager, $id, $args = array(), $fields = array() ) {
            
            $this->fields = $fields;
            $this->news_express_box_label          = $args['news_express_box_label_text'] ;
            $this->news_express_box_add_control    = $args['news_express_box_add_control_text'];
            $this->news_express_field_limit        = $args['news_express_field_limit'];
            $this->categories               = get_categories();
            parent::__construct( $manager, $id, $args );
        }

        protected function render_content() {

            $repeater_id    = $this->id;
            $values         = json_decode( $this->value() );
            $field_count    = count( $values );
            
    ?>
            <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>

            <?php if ( $this->description ) { ?>
                <span class="description customize-control-description">
                    <?php echo wp_kses_post( $this->description ); ?>
                </span>
            <?php } ?>

            <ul class="news-express-repeater-field-control-wrap">
                <?php $this->news_express_get_fields(); ?>
            </ul>

            <input type="hidden" <?php $this->link(); ?> class="news-express-repeater-collector" value="<?php echo esc_attr( $this->value() ); ?>" />
            <input type="hidden" name="<?php echo esc_attr( $repeater_id ).'_count'; ?>" class="field-count" value="<?php echo absint( $field_count ); ?>">
            <input type="hidden" name="field_limit" class="field-limit" value="<?php echo esc_attr( $this->news_express_field_limit ); ?>">
            <button type="button" class="button news-express-repeater-add-control-field"><i class="fa-solid fa-plus"></i><?php echo esc_html( $this->news_express_box_add_control ); ?></button>
    <?php
        }

        private function news_express_get_fields() {

            $fields = $this->fields;
            $values = json_decode( $this->value() );

            if ( is_array( $values ) ) {

                foreach ( $values as $value ) {
                    if ( 'show' === $value->item_visible ) {
                        $item_class = 'item-visible';
                        $dash_icon = 'visibility';
                    } else {
                        $item_class = 'item-not-visible';
                        $dash_icon = 'hidden';
                    }
        ?>
                <li class="news-express-repeater-field-control <?php echo esc_attr( $item_class ); ?>">

                    <div class="heading-wrapper">
                        <span class="field-display dashicons dashicons-<?php echo esc_attr( $dash_icon ); ?>"></span>
                        <span class="news-express-repeater-field-title <?php echo esc_attr( $item_class ); ?>"><?php echo esc_html( $this->news_express_box_label ); ?></span>
                        
                    </div><!-- .heading-wrapper -->
                
                    <div class="news-express-repeater-fields">
                        <?php
                            foreach ( $fields as $key => $field ) {

                                $class = isset( $field['class'] ) ? $field['class'] : '';

                                $field_type  = isset( $field['type'] ) ? $field['type'] : 'none
                                ';
                        ?>
                                <div class="news-express-repeater-field news-express-repeater-type-<?php echo esc_attr( $field_type ).' '.esc_attr( $class ); ?>">

                                    <?php 
                                        $label          = isset( $field['label'] ) ? $field['label'] : '';
                                        $description    = isset( $field['description'] ) ? $field['description'] : '';
                                        $placeholder    = isset( $field['placeholder'] ) ? $field['placeholder'] : '';
                                        $new_value  = isset( $value->$key ) ? $value->$key : '';
                                        $default    = isset( $field['default'] ) ? $field['default'] : '';

                                        if ( 'checkbox' != $field['type'] && 'item_visible' !== $key ) {
                                    ?>
                                            <span class="customize-control-title"><?php echo esc_html( $label ); ?></span>
                                            <span class="description customize-control-description"><?php echo esc_html( $description ); ?></span>
                                    <?php 
                                        }

                                        switch ( $field['type'] ) {

                                            /**
                                             * URL field
                                             */
                                            case 'url':
                                                echo '<input data-default="'.esc_attr( $default ).'" data-name="'.esc_attr( $key ).'" type="text" placeholder="'. esc_attr( $placeholder ) .'" value="'.esc_url( $new_value ).'"/>';
                                                break;
     
                                            /**
                                             * Social Icon field
                                             */
                                            case 'social_icon':
                                                $news_express_social_icons_array = news_express_social_icons_array();
                                                echo '<div class="news-express-repeater-selected-icon"><i class="'. esc_attr( $new_value ) .'"></i><span><i class="fas fa-chevron-down"></i></span></div><ul class="news-express-repeater-icon-list news-express-clearfix">';
                                                foreach ( $news_express_social_icons_array as $news_express_social_icon ) {
                                                    $icon_class = $new_value == $news_express_social_icon ? 'icon-active' : '';
                                                    echo '<li class='. esc_attr( $icon_class ) .'><i class="'. esc_attr( $news_express_social_icon ) .'"></i></li>';
                                                }
                                                echo '</ul><input data-default="'. esc_attr( $default ) .'" type="hidden" value="'. esc_attr( $new_value ) .'" data-name="'. esc_attr( $key ) .'"/>';
                                                break;

                                            case 'hidden' :
                                                echo '<input type="hidden" class="repeater-field-visible-holder" data-default="' .esc_attr( $default ). '" data-name="' .esc_attr( $key ). '" value="' .esc_attr( $new_value ). '">';
                                                break;

                                            default:
                                                break;
                                        }
                                    ?>
                                </div>
                        <?php
                            }
                        ?>
                        <div class="news-express-clearfix news-express-repeater-footer">
                            <div class="alignright">
                            <a class="news-express-repeater-field-remove" href="#remove"><?php esc_html_e( 'Delete', 'news-express' ) ?></a> |
                            <a class="news-express-repeater-field-close" href="#close"><?php esc_html_e( 'Close', 'news-express' ) ?></a>
                            </div>
                        </div><!-- .news-express-repeater-footer -->
                    </div><!-- .news-express-repeater-fields-->
                </li>
        <?php   
                }
            }
        }

    }

endif;