<?php
/**
 * Customizer Blocks Repeater Control
 * 
 * @package News Express
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if (! class_exists( 'News_Express_Control_Blocks_Repeater' ) ) :

     /**
     * Blocks Repeater control
     *
     * @since 1.0.0
     */
    class News_Express_Control_Blocks_Repeater extends WP_Customize_Control {
        
        /**
         * The control type.
         *
         * @access public
         * @var string
         * @since 1.0.0
         */
        public $type = 'news-express-block-repeater';

        /**
         * The repeater field limit count.
         *
         * @access public
         * @var int
         * @since 1.0.0
         */
        public $news_express_field_limit;

        /**
         * constructor
         * 
         */
        public function __construct( $manager, $id, $args ) {

            $this->news_express_field_limit        = isset( $args['news_express_field_limit'] ) ? $args['news_express_field_limit'] : 0;

            parent::__construct( $manager, $id, $args );
        }

        /**
         * Render content
         * 
         */
        public function render_content() {

            $repeater_id    = $this->id;
            
            $defaults = json_decode( $this->setting->default ); // defaults
            $values = json_decode( $this->value() ); // values
            $field_count    = count( $values );
    ?>
            <div class="blocks-repeater-control-wrap">
                <?php
                    $categories = get_categories();

                    foreach ( $values as $control_key => $control ) :
                        if ( false === $control->option ) {
                            $dash_icon = 'hidden';
                            $item_wrap_class = ' news-express-hide';
                        } else {
                            $dash_icon = 'visibility';
                            $item_wrap_class = '';
                        }
                        switch ( $control->type ) {
                            case 'ad-block' :

                ?>
                                <div class="news-express-block ad-block-wrap<?php echo esc_attr( $item_wrap_class ); ?>" block-name="ad-block">

                                    <div class="block-header content-trigger">
                                        <h2 class="block-header-title"><?php esc_html_e( 'Ad Block', 'news-express' ); ?></h2>
                                        <span class="block-settings dashicons dashicons-admin-generic"></span>
                                        <div class="block-header-toggle">
                                            <span class="block-option dashicons dashicons-<?php echo esc_attr( $dash_icon ); ?>"></span>
                                            <input type="checkbox" class="block-repeater-control-field" data-name="option" <?php echo checked( $control->option, true ); ?>/>
                                        </div><!-- .block-header-toggle -->
                                    </div><!-- .block-header -->

                                    <div class="block-content-wrap">
                                        <?php
                                            /**
                                             * upload field for ad block image
                                             */
                                            $ad_img_arg = array(
                                                'title'         => __( 'Ad Block Image', 'news-express' ),
                                                'name'          => 'imgSrc',
                                                'value'         => $control->imgSrc
                                            );
                                            self::render_field( 'upload', $ad_img_arg );

                                            /**
                                             * url field for ad image link
                                             */
                                            $img_link_arg = array(
                                                'title'         => __( 'Ad Block Image Link', 'news-express' ),
                                                'name'          => 'imgUrl',
                                                'value'         => $control->imgUrl
                                            );
                                            self::render_field( 'url', $img_link_arg );

                                            /**
                                             * toggle field for link open in new tab.
                                             */
                                            $new_tab_args = array(
                                                'title'     => __( 'Link open in new tab.', 'news-express' ),
                                                'name'      => 'newTab',
                                                'value'     => $control->newTab,
                                            );
                                            self::render_field( 'toggle', $new_tab_args );
                                        ?>

                                        <div class="action-buttons ad-block">
                                            <div class="close-block"><?php esc_html_e( 'Close', 'news-express' ); ?></div>
                                            <div class="red-button remove-block"><?php esc_html_e( 'Remove', 'news-express' ); ?></div>
                                        </div><!-- .action-buttons -->
                                        
                                    </div><!-- .block-content-wrap -->

                                </div><!-- .ad-block-wrap -->
                <?php
                                break;

                            case 'news-featured' :
                ?>
                                <div class="news-express-block news-featured-block-wrap" block-name="news-featured">
                                    
                                    <div class="block-header content-trigger">
                                        <h2 class="block-header-title"><?php esc_html_e( 'News Featured', 'news-express' ); ?></h2>
                                        <span class="block-settings dashicons dashicons-admin-generic"></span>
                                        <div class="block-header-toggle">
                                            <span class="block-option dashicons dashicons-<?php echo esc_attr( $dash_icon ); ?>"></span>
                                            <input type="checkbox" class="block-repeater-control-field" data-name="option" <?php echo checked( $control->option, true ); ?>/>
                                        </div><!-- .block-header-toggle -->
                                    </div><!-- .block-header -->

                                    <div class="block-content-wrap">
                                        <?php
                                            /**
                                             * text field for block title
                                             */
                                            $block_title_arg = array(
                                                'title'         => __( 'Block Title', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide title.', 'news-express' ),
                                                'name'          => 'blockTitle',
                                                'value'         => $control->blockTitle
                                            );
                                            self::render_field( 'text', $block_title_arg );

                                            /**
                                             *  text field for block Description
                                             */
                                            $block_description_arg = array(
                                                'title'         => __( 'Block Description', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockDescription',
                                                'value'         => $control->blockDescription
                                            );
                                            self::render_field( 'text', $block_description_arg );

                                            /**
                                             * text field for block url
                                             */
                                            $block_url_label_arg = array(
                                                'title'         => __( 'See More', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockLabel',
                                                'value'         => $control->blockLabel
                                            );
                                            self::render_field( 'text', $block_url_label_arg );

                                            /**
                                             * url field for button link
                                             */
                                            $block_url_link_arg = array(
                                                'title'         => __( 'Block Link', 'news-express' ),
                                                'name'          => 'Url',
                                                'value'         => $control->Url
                                            );
                                            self::render_field( 'url', $block_url_link_arg );

                                            /**
                                             * block query group
                                             */
                                            $block_query_group_arg = array(
                                                'title'         => __( 'Block Query', 'news-express' ),
                                                'description'   => __( 'Click Icon to expand the fields.', 'news-express' )
                                            );
                                            self::render_field( 'group_title', $block_query_group_arg );

                                            /**
                                             * block query wrap start
                                             */
                                            self::render_field( 'field_group_start' );

                                            /**
                                             * category dropdown field for block category
                                             */
                                            $block_cat_args = array(
                                                'title' => __( 'Block Category', 'news-express' ),
                                                'name'  => 'category',
                                                'value' => $control->category
                                            );
                                            self::render_field( 'category_dropdown', $block_cat_args );

                                            /**
                                             * select field for posts orderby
                                             */
                                            $posts_orderby_args = array(
                                                'title'     => __( 'Posts Order by', 'news-express' ),
                                                'name'      => 'postOrderby',
                                                'value'     => $control->postOrderby,
                                                'options'   => array(
                                                    'date-desc'     => __( 'Newest - Oldest', 'news-express' ),
                                                    'date-asc'      => __( 'Oldest - Newest', 'news-express' ),
                                                    'title-asc'     => __( 'A - Z', 'news-express' ),
                                                    'title-desc'    => __( 'Z - A', 'news-express' ),
                                                    'rand-desc'     => __( 'Random', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_orderby_args );

                                            /**
                                             * select field for posts date filter
                                             */
                                            $posts_datefilter_args = array(
                                                'title'     => __( 'Posts date filter', 'news-express' ),
                                                'name'      => 'postDatefilter',
                                                'value'     => $control->postDatefilter,
                                                'options'   => array(
                                                    'all'     => __( 'All', 'news-express' ),
                                                    'today'      => __( 'Today', 'news-express' ),
                                                    'this-week'     => __( 'This Week', 'news-express' ),
                                                    'last-week'    => __( 'Last Week', 'news-express' ),
                                                    'this-month'     => __( 'This Month', 'news-express' ),
                                                    'last-month'     => __( 'Last Month', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_datefilter_args );

                                            /**
                                             * number field for post count
                                             */
                                            $block_postcount_args = array(
                                                'title'         => __( 'Number of posts', 'news-express' ),
                                                'name'          => 'postCount',
                                                'value'         => $control->postCount,
                                                'input_attrs'   => array(
                                                    'min'   => 1,
                                                    'max'   => 7,
                                                    'step'  => 1
                                                )
                                            );
                                            self::render_field( 'number', $block_postcount_args );

                                            /**
                                             * block query wrap end
                                             */
                                            self::render_field( 'field_group_end' );

                                            /**
                                             * radio image field for block layout
                                             */
                                            $block_layout_args = array(
                                                'title'         => __( 'Block Layouts', 'news-express' ),
                                                'description'   => __( 'Choose from available layouts.', 'news-express' ),
                                                'name'          => 'blocklayout',
                                                'value'         => $control->blocklayout,
                                                'choices'       => array(
                                                    'one'    => array(
                                                        'label' => esc_html( 'Layout One' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-featured-layout-one.png'
                                                    ),
                                                    'two'    => array(
                                                        'label' => esc_html( 'Layout Two' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-featured-layout-two.png'
                                                    )
                                                ),

                                            );
                                            self::render_field( 'selector', $block_layout_args );

                                            /**
                                             * toggle field for posts cats
                                             */
                                            $posts_cats_args = array(
                                                'title'     => __( 'Show posts categories lists', 'news-express' ),
                                                'name'      => 'postCats',
                                                'value'     => $control->postCats,
                                            );
                                            self::render_field( 'toggle', $posts_cats_args );

                                            /**
                                             * toggle field for posts author
                                             */
                                            $posts_author_args = array(
                                                'title'     => __( 'Show posts author', 'news-express' ),
                                                'name'      => 'postAuthor',
                                                'value'     => $control->postAuthor,
                                            );
                                            self::render_field( 'toggle', $posts_author_args );

                                            /**
                                             * toggle field for posts date
                                             */
                                            $posts_date_args = array(
                                                'title'     => __( 'Show posts date', 'news-express' ),
                                                'name'      => 'postDate',
                                                'value'     => $control->postDate,
                                            );
                                            self::render_field( 'toggle', $posts_date_args );
                                         ?>

                                        <div class="action-buttons news-featured">
                                            <div class="close-block"><?php esc_html_e( 'Close', 'news-express' ); ?></div>
                                            <div class="red-button remove-block"><?php esc_html_e( 'Remove', 'news-express' ); ?></div>
                                        </div><!-- .action-buttons -->

                                    </div><!-- .block-content-wrap -->

                                </div><!-- .news-featured-block-wrap -->
                        <?php
                                break;

                            case 'news-block' :
                        ?>
                                <div class="news-express-block news-block-block-wrap<?php echo esc_attr( $item_wrap_class ); ?>" block-name="news-block">

                                    <div class="block-header content-trigger">
                                        <h2 class="block-header-title"><?php esc_html_e( 'News Block', 'news-express' ); ?></h2>
                                        <span class="block-settings dashicons dashicons-admin-generic"></span>
                                        <div class="block-header-toggle">
                                            <span class="block-option dashicons dashicons-<?php echo esc_attr( $dash_icon ); ?>"></span>
                                            <input type="checkbox" class="block-repeater-control-field" data-name="option" <?php echo checked( $control->option, true ); ?>/>
                                        </div><!-- .block-header-toggle -->
                                    </div><!-- .block-header -->

                                    <div class="block-content-wrap">
                                        <?php
                                            /**
                                             * text field for block title
                                             */
                                            $block_title_arg = array(
                                                'title'         => __( 'Block Title', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide title.', 'news-express' ),
                                                'name'          => 'blockTitle',
                                                'value'         => $control->blockTitle
                                            );
                                            self::render_field( 'text', $block_title_arg );

                                            /**
                                             *  text field for block Description
                                             */
                                            $block_description_arg = array(
                                                'title'         => __( 'Block Description', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockDescription',
                                                'value'         => $control->blockDescription
                                            );
                                            self::render_field( 'text', $block_description_arg );

                                            /**
                                             * text field for block url
                                             */
                                            $block_url_label_arg = array(
                                                'title'         => __( 'See More', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockLabel',
                                                'value'         => $control->blockLabel
                                            );
                                            self::render_field( 'text', $block_url_label_arg );

                                            /**
                                             * url field for button link
                                             */
                                            $block_url_link_arg = array(
                                                'title'         => __( 'Block Link', 'news-express' ),
                                                'name'          => 'Url',
                                                'value'         => $control->Url
                                            );
                                            self::render_field( 'url', $block_url_link_arg );

                                            /**
                                             * block query group
                                             */
                                            $block_query_group_arg = array(
                                                'title'         => __( 'Block Query', 'news-express' ),
                                                'description'   => __( 'Click Icon to expand the fields.', 'news-express' )
                                            );
                                            self::render_field( 'group_title', $block_query_group_arg );

                                            /**
                                             * block query wrap start
                                             */
                                            self::render_field( 'field_group_start' );

                                            /**
                                             * category dropdown field for block category
                                             */
                                            $block_cat_args = array(
                                                'title' => __( 'Block Category', 'news-express' ),
                                                'name'  => 'category',
                                                'value' => $control->category
                                            );
                                            self::render_field( 'category_dropdown', $block_cat_args );

                                            /**
                                             * select field for posts orderby
                                             */
                                            $posts_orderby_args = array(
                                                'title'     => __( 'Posts Order by', 'news-express' ),
                                                'name'      => 'postOrderby',
                                                'value'     => $control->postOrderby,
                                                'options'   => array(
                                                    'date-desc'     => __( 'Newest - Oldest', 'news-express' ),
                                                    'date-asc'      => __( 'Oldest - Newest', 'news-express' ),
                                                    'title-asc'     => __( 'A - Z', 'news-express' ),
                                                    'title-desc'    => __( 'Z - A', 'news-express' ),
                                                    'rand-desc'     => __( 'Random', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_orderby_args );

                                            /**
                                             * select field for posts date filter
                                             */
                                            $posts_datefilter_args = array(
                                                'title'     => __( 'Posts date filter', 'news-express' ),
                                                'name'      => 'postDatefilter',
                                                'value'     => $control->postDatefilter,
                                                'options'   => array(
                                                    'all'           => __( 'All', 'news-express' ),
                                                    'today'         => __( 'Today', 'news-express' ),
                                                    'this-week'     => __( 'This Week', 'news-express' ),
                                                    'last-week'     => __( 'Last Week', 'news-express' ),
                                                    'this-month'    => __( 'This Month', 'news-express' ),
                                                    'last-month'    => __( 'Last Month', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_datefilter_args );

                                            /**
                                             * number field for post count
                                             */
                                            $block_postcount_args = array(
                                                'title'         => __( 'Number of posts', 'news-express' ),
                                                'name'          => 'postCount',
                                                'value'         => $control->postCount,
                                                'input_attrs'   => array(
                                                    'min'   => 1,
                                                    'max'   => 7,
                                                    'step'  => 1
                                                )
                                            );
                                            self::render_field( 'number', $block_postcount_args );

                                            /**
                                             * block query wrap end
                                             */
                                            self::render_field( 'field_group_end' );

                                            /**
                                             * radio image field for block layout
                                             */
                                            $block_layout_args = array(
                                                'title'         => __( 'Block Layouts', 'news-express' ),
                                                'description'   => __( 'Choose from available layouts.', 'news-express' ),
                                                'name'          => 'blocklayout',
                                                'value'         => $control->blocklayout,
                                                'choices'       => array(
                                                    'one'    => array(
                                                        'label' => esc_html( 'Layout One' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-block-one.png'
                                                    ),
                                                    'two'    => array(
                                                        'label' => esc_html( 'Layout Two' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-block-two.png'
                                                    )
                                                ),

                                            );
                                            self::render_field( 'selector', $block_layout_args );

                                            /**
                                             * toggle field for posts cats
                                             */
                                            $posts_cats_args = array(
                                                'title'     => __( 'Show posts categories lists', 'news-express' ),
                                                'name'      => 'postCats',
                                                'value'     => $control->postCats,
                                            );
                                            self::render_field( 'toggle', $posts_cats_args );

                                            /**
                                             * toggle field for posts author
                                             */
                                            $posts_author_args = array(
                                                'title'     => __( 'Show posts author', 'news-express' ),
                                                'name'      => 'postAuthor',
                                                'value'     => $control->postAuthor,
                                            );
                                            self::render_field( 'toggle', $posts_author_args );

                                            /**
                                             * toggle field for posts date
                                             */
                                            $posts_date_args = array(
                                                'title'     => __( 'Show posts date', 'news-express' ),
                                                'name'      => 'postDate',
                                                'value'     => $control->postDate,
                                            );
                                            self::render_field( 'toggle', $posts_date_args );

                                            /**
                                             * toggle field for posts comment
                                             */
                                            $posts_comment_args = array(
                                                'title'     => __( 'Show posts comment', 'news-express' ),
                                                'name'      => 'postComment',
                                                'value'     => $control->postComment,
                                            );
                                            self::render_field( 'toggle', $posts_comment_args );

                                            /**
                                             * toggle field for posts more
                                             */
                                            $posts_more_args = array(
                                                'title'     => __( 'Show posts more', 'news-express' ),
                                                'name'      => 'postMore',
                                                'value'     => $control->postMore,
                                            );
                                            self::render_field( 'toggle', $posts_more_args );
                                        ?>

                                        <div class="action-buttons news-block">
                                            <div class="close-block"><?php esc_html_e( 'Close', 'news-express' ); ?></div>
                                            <div class="red-button remove-block"><?php esc_html_e( 'Remove', 'news-express' ); ?></div>
                                        </div><!-- .action-buttons -->
                                    </div><!-- .block-content-wrap -->

                                </div><!-- .news-block-block-wrap -->
                            <?php
                                break;

                            case 'news-grid' :
                        ?>
                                <div class="news-express-block news-grid-block-wrap<?php echo esc_attr( $item_wrap_class ); ?>" block-name="news-grid">

                                    <div class="block-header content-trigger">
                                        <h2 class="block-header-title"><?php esc_html_e( 'News Grid', 'news-express' ); ?></h2>
                                        <span class="block-settings dashicons dashicons-admin-generic"></span>
                                        <div class="block-header-toggle">
                                            <span class="block-option dashicons dashicons-<?php echo esc_attr( $dash_icon ); ?>"></span>
                                            <input type="checkbox" class="block-repeater-control-field" data-name="option" <?php echo checked( $control->option, true ); ?>/>
                                        </div><!-- .block-header-toggle -->
                                    </div><!-- .block-header -->

                                    <div class="block-content-wrap">
                                        <?php
                                            /**
                                             * text field for block title
                                             */
                                            $block_title_arg = array(
                                                'title'         => __( 'Block Title', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide title.', 'news-express' ),
                                                'name'          => 'blockTitle',
                                                'value'         => $control->blockTitle
                                            );
                                            self::render_field( 'text', $block_title_arg );

                                            /**
                                             *  text field for block Description
                                             */
                                            $block_description_arg = array(
                                                'title'         => __( 'Block Description', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockDescription',
                                                'value'         => $control->blockDescription
                                            );
                                            self::render_field( 'text', $block_description_arg );

                                           /**
                                             * text field for block url
                                             */
                                            $block_url_label_arg = array(
                                                'title'         => __( 'See More', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockLabel',
                                                'value'         => $control->blockLabel
                                            );
                                            self::render_field( 'text', $block_url_label_arg );

                                            /**
                                             * url field for button link
                                             */
                                            $block_url_link_arg = array(
                                                'title'         => __( 'Block Link', 'news-express' ),
                                                'name'          => 'Url',
                                                'value'         => $control->Url
                                            );
                                            self::render_field( 'url', $block_url_link_arg );

                                            /**
                                             * block query group
                                             */
                                            $block_query_group_arg = array(
                                                'title'         => __( 'Block Query', 'news-express' ),
                                                'description'   => __( 'Click Icon to expand the fields.', 'news-express' )
                                            );
                                            self::render_field( 'group_title', $block_query_group_arg );

                                            /**
                                             * block query wrap start
                                             */
                                            self::render_field( 'field_group_start' );

                                            /**
                                             * category dropdown field for block category
                                             */
                                            $block_cat_args = array(
                                                'title' => __( 'Block Category', 'news-express' ),
                                                'name'  => 'category',
                                                'value' => $control->category
                                            );
                                            self::render_field( 'category_dropdown', $block_cat_args );

                                            /**
                                             * select field for posts orderby
                                             */
                                            $posts_orderby_args = array(
                                                'title'     => __( 'Posts Order by', 'news-express' ),
                                                'name'      => 'postOrderby',
                                                'value'     => $control->postOrderby,
                                                'options'   => array(
                                                    'date-desc'     => __( 'Newest - Oldest', 'news-express' ),
                                                    'date-asc'      => __( 'Oldest - Newest', 'news-express' ),
                                                    'title-asc'     => __( 'A - Z', 'news-express' ),
                                                    'title-desc'    => __( 'Z - A', 'news-express' ),
                                                    'rand-desc'     => __( 'Random', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_orderby_args );

                                            /**
                                             * select field for posts date filter
                                             */
                                            $posts_datefilter_args = array(
                                                'title'     => __( 'Posts date filter', 'news-express' ),
                                                'name'      => 'postDatefilter',
                                                'value'     => $control->postDatefilter,
                                                'options'   => array(
                                                    'all'           => __( 'All', 'news-express' ),
                                                    'today'         => __( 'Today', 'news-express' ),
                                                    'this-week'     => __( 'This Week', 'news-express' ),
                                                    'last-week'     => __( 'Last Week', 'news-express' ),
                                                    'this-month'    => __( 'This Month', 'news-express' ),
                                                    'last-month'    => __( 'Last Month', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_datefilter_args );

                                            /**
                                             * number field for post count
                                             */
                                            $block_postcount_args = array(
                                                'title'         => __( 'Number of posts', 'news-express' ),
                                                'name'          => 'postCount',
                                                'value'         => $control->postCount,
                                                'input_attrs'   => array(
                                                    'min'   => 1,
                                                    'max'   => 7,
                                                    'step'  => 1
                                                )
                                            );
                                            self::render_field( 'number', $block_postcount_args );

                                            /**
                                             * block query wrap end
                                             */
                                            self::render_field( 'field_group_end' );

                                            /**
                                             * radio image field for block layout
                                             */
                                            $block_layout_args = array(
                                                'title'         => __( 'Block Layouts', 'news-express' ),
                                                'description'   => __( 'Choose from available layouts.', 'news-express' ),
                                                'name'          => 'blocklayout',
                                                'value'         => $control->blocklayout,
                                                'choices'       => array(
                                                    'one'    => array(
                                                        'label' => esc_html( 'Layout One' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-grid-one.png'
                                                    ),
                                                    'two'    => array(
                                                        'label' => esc_html( 'Layout Two' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-grid-two.png'
                                                    )
                                                ),

                                            );
                                            self::render_field( 'selector', $block_layout_args );

                                            /**
                                             * toggle field for posts cats
                                             */
                                            $posts_cats_args = array(
                                                'title'     => __( 'Show posts categories lists', 'news-express' ),
                                                'name'      => 'postCats',
                                                'value'     => $control->postCats,
                                            );
                                            self::render_field( 'toggle', $posts_cats_args );

                                            /**
                                             * toggle field for posts author
                                             */
                                            $posts_author_args = array(
                                                'title'     => __( 'Show posts author', 'news-express' ),
                                                'name'      => 'postAuthor',
                                                'value'     => $control->postAuthor,
                                            );
                                            self::render_field( 'toggle', $posts_author_args );

                                        ?>

                                        <div class="action-buttons news-grid">
                                            <div class="close-block"><?php esc_html_e( 'Close', 'news-express' ); ?></div>
                                            <div class="red-button remove-block"><?php esc_html_e( 'Remove', 'news-express' ); ?></div>
                                        </div><!-- .action-buttons -->
                                    </div><!-- .block-content-wrap -->

                                </div><!-- .news-grid-block-wrap -->
                            <?php
                                break;

                                case 'news-middle-grid' :
                        ?>
                                <div class="news-express-block news-middle-grid-block-wrap<?php echo esc_attr( $item_wrap_class ); ?>" block-name="news-middle-grid">

                                    <div class="block-header content-trigger">
                                        <h2 class="block-header-title"><?php esc_html_e( 'News Middle Grid', 'news-express' ); ?></h2>
                                        <span class="block-settings dashicons dashicons-admin-generic"></span>
                                        <div class="block-header-toggle">
                                            <span class="block-option dashicons dashicons-<?php echo esc_attr( $dash_icon ); ?>"></span>
                                            <input type="checkbox" class="block-repeater-control-field" data-name="option" <?php echo checked( $control->option, true ); ?>/>
                                        </div><!-- .block-header-toggle -->
                                    </div><!-- .block-header -->

                                    <div class="block-content-wrap">
                                        <?php
                                            /**
                                             * text field for block title
                                             */
                                            $block_title_arg = array(
                                                'title'         => __( 'Block Title', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide title.', 'news-express' ),
                                                'name'          => 'blockTitle',
                                                'value'         => $control->blockTitle
                                            );
                                            self::render_field( 'text', $block_title_arg );

                                            /**
                                             *  text field for block Description
                                             */
                                            $block_description_arg = array(
                                                'title'         => __( 'Block Description', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockDescription',
                                                'value'         => $control->blockDescription
                                            );
                                            self::render_field( 'text', $block_description_arg );
                                           /**
                                             * text field for block url
                                             */
                                            $block_url_label_arg = array(
                                                'title'         => __( 'See More', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockLabel',
                                                'value'         => $control->blockLabel
                                            );
                                            self::render_field( 'text', $block_url_label_arg );

                                            /**
                                             * url field for button link
                                             */
                                            $block_url_link_arg = array(
                                                'title'         => __( 'Block Link', 'news-express' ),
                                                'name'          => 'Url',
                                                'value'         => $control->Url
                                            );
                                            self::render_field( 'url', $block_url_link_arg );

                                            /**
                                             * block query group
                                             */
                                            $block_query_group_arg = array(
                                                'title'         => __( 'Block Query', 'news-express' ),
                                                'description'   => __( 'Click Icon to expand the fields.', 'news-express' )
                                            );
                                            self::render_field( 'group_title', $block_query_group_arg );

                                            /**
                                             * block query wrap start
                                             */
                                            self::render_field( 'field_group_start' );

                                            /**
                                             * category dropdown field for block category
                                             */
                                            $block_cat_args = array(
                                                'title' => __( 'Block Category', 'news-express' ),
                                                'name'  => 'category',
                                                'value' => $control->category
                                            );
                                            self::render_field( 'category_dropdown', $block_cat_args );

                                            /**
                                             * select field for posts orderby
                                             */
                                            $posts_orderby_args = array(
                                                'title'     => __( 'Posts Order by', 'news-express' ),
                                                'name'      => 'postOrderby',
                                                'value'     => $control->postOrderby,
                                                'options'   => array(
                                                    'date-desc'     => __( 'Newest - Oldest', 'news-express' ),
                                                    'date-asc'      => __( 'Oldest - Newest', 'news-express' ),
                                                    'title-asc'     => __( 'A - Z', 'news-express' ),
                                                    'title-desc'    => __( 'Z - A', 'news-express' ),
                                                    'rand-desc'     => __( 'Random', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_orderby_args );

                                            /**
                                             * select field for posts date filter
                                             */
                                            $posts_datefilter_args = array(
                                                'title'     => __( 'Posts date filter', 'news-express' ),
                                                'name'      => 'postDatefilter',
                                                'value'     => $control->postDatefilter,
                                                'options'   => array(
                                                    'all'           => __( 'All', 'news-express' ),
                                                    'today'         => __( 'Today', 'news-express' ),
                                                    'this-week'     => __( 'This Week', 'news-express' ),
                                                    'last-week'     => __( 'Last Week', 'news-express' ),
                                                    'this-month'    => __( 'This Month', 'news-express' ),
                                                    'last-month'    => __( 'Last Month', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_datefilter_args );

                                            /**
                                             * number field for post count
                                             */
                                            $block_postcount_args = array(
                                                'title'         => __( 'Number of posts', 'news-express' ),
                                                'name'          => 'postCount',
                                                'value'         => $control->postCount,
                                                'input_attrs'   => array(
                                                    'min'   => 1,
                                                    'max'   => 7,
                                                    'step'  => 1
                                                )
                                            );
                                            self::render_field( 'number', $block_postcount_args );

                                            /**
                                             * block query wrap end
                                             */
                                            self::render_field( 'field_group_end' );

                                            /**
                                             * radio image field for block layout
                                             */
                                            $block_layout_args = array(
                                                'title'         => __( 'Block Layouts', 'news-express' ),
                                                'description'   => __( 'Choose from available layouts.', 'news-express' ),
                                                'name'          => 'blocklayout',
                                                'value'         => $control->blocklayout,
                                                'choices'       => array(
                                                    'one'    => array(
                                                        'label' => esc_html( 'Layout One' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-middle-grid-one.png'
                                                    ),
                                                    'two'    => array(
                                                        'label' => esc_html( 'Layout Two' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-middle-grid-two.png'
                                                    )
                                                ),

                                            );
                                            self::render_field( 'selector', $block_layout_args );

                                            /**
                                             * toggle field for posts cats
                                             */
                                            $posts_cats_args = array(
                                                'title'     => __( 'Show posts categories lists', 'news-express' ),
                                                'name'      => 'postCats',
                                                'value'     => $control->postCats,
                                            );
                                            self::render_field( 'toggle', $posts_cats_args );

                                            /**
                                             * toggle field for posts author
                                             */
                                            $posts_author_args = array(
                                                'title'     => __( 'Show posts author', 'news-express' ),
                                                'name'      => 'postAuthor',
                                                'value'     => $control->postAuthor,
                                            );
                                            self::render_field( 'toggle', $posts_author_args );
                                            ?>

                                        <div class="action-buttons news-middle-grid">
                                            <div class="close-block"><?php esc_html_e( 'Close', 'news-express' ); ?></div>
                                            <div class="red-button remove-block"><?php esc_html_e( 'Remove', 'news-express' ); ?></div>
                                        </div><!-- .action-buttons -->
                                    </div><!-- .block-content-wrap -->

                                </div><!-- .news-middle-grid-block-wrap -->
                            <?php
                                break;
                            case 'news-carousel' :
                        ?>
                                <div class="news-express-block news-carousel-block-wrap<?php echo esc_attr( $item_wrap_class ); ?>" block-name="news-carousel">

                                    <div class="block-header content-trigger">
                                        <h2 class="block-header-title"><?php esc_html_e( 'News Carousel', 'news-express' ); ?></h2>
                                        <span class="block-settings dashicons dashicons-admin-generic"></span>
                                        <div class="block-header-toggle">
                                            <span class="block-option dashicons dashicons-<?php echo esc_attr( $dash_icon ); ?>"></span>
                                            <input type="checkbox" class="block-repeater-control-field" data-name="option" <?php echo checked( $control->option, true ); ?>/>
                                        </div><!-- .block-header-toggle -->
                                    </div><!-- .block-header -->

                                    <div class="block-content-wrap">
                                        <?php
                                            /**
                                             * text field for block title
                                             */
                                            $block_title_arg = array(
                                                'title'         => __( 'Block Title', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide title.', 'news-express' ),
                                                'name'          => 'blockTitle',
                                                'value'         => $control->blockTitle
                                            );
                                            self::render_field( 'text', $block_title_arg );
                                            
                                            /**
                                             *  text field for block Description
                                             */
                                            $block_description_arg = array(
                                                'title'         => __( 'Block Description', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockDescription',
                                                'value'         => $control->blockDescription
                                            );
                                            self::render_field( 'text', $block_description_arg );
                                            
                                            /**
                                             * text field for block url
                                             */
                                            $block_url_label_arg = array(
                                                'title'         => __( 'See More', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockLabel',
                                                'value'         => $control->blockLabel
                                            );
                                            self::render_field( 'text', $block_url_label_arg );

                                            /**
                                             * url field for button link
                                             */
                                            $block_url_link_arg = array(
                                                'title'         => __( 'Block Link', 'news-express' ),
                                                'name'          => 'Url',
                                                'value'         => $control->Url
                                            );
                                            self::render_field( 'url', $block_url_link_arg );

                                            /**
                                             * block query group
                                             */
                                            $block_query_group_arg = array(
                                                'title'         => __( 'Block Query', 'news-express' ),
                                                'description'   => __( 'Click Icon to expand the fields.', 'news-express' )
                                            );
                                            self::render_field( 'group_title', $block_query_group_arg );

                                            /**
                                             * block query wrap start
                                             */
                                            self::render_field( 'field_group_start' );

                                            /**
                                             * category dropdown field for block category
                                             */
                                            $block_cat_args = array(
                                                'title' => __( 'Block Category', 'news-express' ),
                                                'name'  => 'category',
                                                'value' => $control->category
                                            );
                                            self::render_field( 'category_dropdown', $block_cat_args );

                                            /**
                                             * select field for posts orderby
                                             */
                                            $posts_orderby_args = array(
                                                'title'     => __( 'Posts Order by', 'news-express' ),
                                                'name'      => 'postOrderby',
                                                'value'     => $control->postOrderby,
                                                'options'   => array(
                                                    'date-desc'     => __( 'Newest - Oldest', 'news-express' ),
                                                    'date-asc'      => __( 'Oldest - Newest', 'news-express' ),
                                                    'title-asc'     => __( 'A - Z', 'news-express' ),
                                                    'title-desc'    => __( 'Z - A', 'news-express' ),
                                                    'rand-desc'     => __( 'Random', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_orderby_args );

                                            /**
                                             * select field for posts date filter
                                             */
                                            $posts_datefilter_args = array(
                                                'title'     => __( 'Posts date filter', 'news-express' ),
                                                'name'      => 'postDatefilter',
                                                'value'     => $control->postDatefilter,
                                                'options'   => array(
                                                    'all'           => __( 'All', 'news-express' ),
                                                    'today'         => __( 'Today', 'news-express' ),
                                                    'this-week'     => __( 'This Week', 'news-express' ),
                                                    'last-week'     => __( 'Last Week', 'news-express' ),
                                                    'this-month'    => __( 'This Month', 'news-express' ),
                                                    'last-month'    => __( 'Last Month', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_datefilter_args );

                                            /**
                                             * number field for post count
                                             */
                                            $block_postcount_args = array(
                                                'title'         => __( 'Number of posts', 'news-express' ),
                                                'name'          => 'postCount',
                                                'value'         => $control->postCount,
                                                'input_attrs'   => array(
                                                    'min'   => 1,
                                                    'max'   => 7,
                                                    'step'  => 1
                                                )
                                            );
                                            self::render_field( 'number', $block_postcount_args );

                                            /**
                                             * block query wrap end
                                             */
                                            self::render_field( 'field_group_end' );

                                            /**
                                             * radio image field for block layout
                                             */
                                            $block_layout_args = array(
                                                'title'         => __( 'Block Layouts', 'news-express' ),
                                                'description'   => __( 'Choose from available layouts.', 'news-express' ),
                                                'name'          => 'blocklayout',
                                                'value'         => $control->blocklayout,
                                                'choices'       => array(
                                                    'one'    => array(
                                                        'label' => esc_html( 'Layout One' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-carousel-one.png'
                                                    ),
                                                    'two'    => array(
                                                        'label' => esc_html( 'Layout Two' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-carousel-two.png'
                                                    )
                                                ),

                                            );
                                            self::render_field( 'selector', $block_layout_args );
                                        ?>

                                        <div class="action-buttons news-carousel">
                                            <div class="close-block"><?php esc_html_e( 'Close', 'news-express' ); ?></div>
                                            <div class="red-button remove-block"><?php esc_html_e( 'Remove', 'news-express' ); ?></div>
                                        </div><!-- .action-buttons -->
                                    </div><!-- .block-content-wrap -->

                                </div><!-- .news-carousel-block-wrap -->
                            <?php
                                break;

                            case 'news-list' :
                ?>
                                <div class="news-express-block news-list-block-wrap" block-name="news-list">
                                    
                                    <div class="block-header content-trigger">
                                        <h2 class="block-header-title"><?php esc_html_e( 'News List', 'news-express' ); ?></h2>
                                        <span class="block-settings dashicons dashicons-admin-generic"></span>
                                        <div class="block-header-toggle">
                                            <span class="block-option dashicons dashicons-<?php echo esc_attr( $dash_icon ); ?>"></span>
                                            <input type="checkbox" class="block-repeater-control-field" data-name="option" <?php echo checked( $control->option, true ); ?>/>
                                        </div><!-- .block-header-toggle -->
                                    </div><!-- .block-header -->

                                    <div class="block-content-wrap">
                                        <?php
                                            /**
                                             * text field for block title
                                             */
                                            $block_title_arg = array(
                                                'title'         => __( 'Block Title', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide title.', 'news-express' ),
                                                'name'          => 'blockTitle',
                                                'value'         => $control->blockTitle
                                            );
                                            self::render_field( 'text', $block_title_arg );
                                           
                                            /**
                                             *  text field for block Description
                                             */
                                            $block_description_arg = array(
                                                'title'         => __( 'Block Description', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockDescription',
                                                'value'         => $control->blockDescription
                                            );
                                            self::render_field( 'text', $block_description_arg );

                                            /**
                                             * text field for block url
                                             */
                                            $block_url_label_arg = array(
                                                'title'         => __( 'See More', 'news-express' ),
                                                'description'   => __( 'Leave blank to hide description.', 'news-express' ),
                                                'name'          => 'blockLabel',
                                                'value'         => $control->blockLabel
                                            );
                                            self::render_field( 'text', $block_url_label_arg );

                                            /**
                                             * url field for button link
                                             */
                                            $block_url_link_arg = array(
                                                'title'         => __( 'Block Link', 'news-express' ),
                                                'name'          => 'Url',
                                                'value'         => $control->Url
                                            );
                                            self::render_field( 'url', $block_url_link_arg );

                                            /**
                                             * block query group
                                             */
                                            $block_query_group_arg = array(
                                                'title'         => __( 'Block Query', 'news-express' ),
                                                'description'   => __( 'Click Icon to expand the fields.', 'news-express' )
                                            );
                                            self::render_field( 'group_title', $block_query_group_arg );

                                            /**
                                             * block query wrap start
                                             */
                                            self::render_field( 'field_group_start' );

                                            /**
                                             * category dropdown field for block category
                                             */
                                            $block_cat_args = array(
                                                'title' => __( 'Block Category', 'news-express' ),
                                                'name'  => 'category',
                                                'value' => $control->category
                                            );
                                            self::render_field( 'category_dropdown', $block_cat_args );

                                            /**
                                             * select field for posts orderby
                                             */
                                            $posts_orderby_args = array(
                                                'title'     => __( 'Posts Order by', 'news-express' ),
                                                'name'      => 'postOrderby',
                                                'value'     => $control->postOrderby,
                                                'options'   => array(
                                                    'date-desc'     => __( 'Newest - Oldest', 'news-express' ),
                                                    'date-asc'      => __( 'Oldest - Newest', 'news-express' ),
                                                    'title-asc'     => __( 'A - Z', 'news-express' ),
                                                    'title-desc'    => __( 'Z - A', 'news-express' ),
                                                    'rand-desc'     => __( 'Random', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_orderby_args );

                                            /**
                                             * select field for posts date filter
                                             */
                                            $posts_datefilter_args = array(
                                                'title'     => __( 'Posts date filter', 'news-express' ),
                                                'name'      => 'postDatefilter',
                                                'value'     => $control->postDatefilter,
                                                'options'   => array(
                                                    'all'           => __( 'All', 'news-express' ),
                                                    'today'         => __( 'Today', 'news-express' ),
                                                    'this-week'     => __( 'This Week', 'news-express' ),
                                                    'last-week'     => __( 'Last Week', 'news-express' ),
                                                    'this-month'    => __( 'This Month', 'news-express' ),
                                                    'last-month'    => __( 'Last Month', 'news-express' ),
                                                )
                                            );
                                            self::render_field( 'select', $posts_datefilter_args );

                                            /**
                                             * number field for post count
                                             */
                                            $block_postcount_args = array(
                                                'title'         => __( 'Number of posts', 'news-express' ),
                                                'name'          => 'postCount',
                                                'value'         => $control->postCount,
                                                'input_attrs'   => array(
                                                    'min'   => 1,
                                                    'max'   => 15,
                                                    'step'  => 1
                                                )
                                            );
                                            self::render_field( 'number', $block_postcount_args );

                                            /**
                                             * block query wrap end
                                             */
                                            self::render_field( 'field_group_end' );

                                            /**
                                             * radio image field for block layout
                                             */
                                            $block_layout_args = array(
                                                'title'         => __( 'Block Layouts', 'news-express' ),
                                                'description'   => __( 'Choose from available layouts.', 'news-express' ),
                                                'name'          => 'blocklayout',
                                                'value'         => $control->blocklayout,
                                                'choices'       => array(
                                                    'one'    => array(
                                                        'label' => esc_html( 'Layout One' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-list-one.png'
                                                    ),
                                                    'two'    => array(
                                                        'label' => esc_html( 'Layout Two' ),
                                                        'img'   => get_template_directory_uri() . '/inc/customizer/assets/images/news-list-two.png'
                                                    )
                                                ),

                                            );
                                            self::render_field( 'selector', $block_layout_args );

                                            /**
                                             * toggle field for posts cats
                                             */
                                            $posts_cats_args = array(
                                                'title'     => __( 'Show posts categories lists', 'news-express' ),
                                                'name'      => 'postCats',
                                                'value'     => $control->postCats,
                                            );
                                            self::render_field( 'toggle', $posts_cats_args );

                                            /**
                                             * toggle field for posts author
                                             */
                                            $posts_author_args = array(
                                                'title'     => __( 'Show posts author', 'news-express' ),
                                                'name'      => 'postAuthor',
                                                'value'     => $control->postAuthor,
                                            );
                                            self::render_field( 'toggle', $posts_author_args );

                                            /**
                                             * toggle field for posts date
                                             */
                                            $posts_date_args = array(
                                                'title'     => __( 'Show posts date', 'news-express' ),
                                                'name'      => 'postDate',
                                                'value'     => $control->postDate,
                                            );
                                            self::render_field( 'toggle', $posts_date_args );

                                            /**
                                             * toggle field for posts comment
                                             */
                                            $posts_comment_args = array(
                                                'title'     => __( 'Show posts comment', 'news-express' ),
                                                'name'      => 'postComment',
                                                'value'     => $control->postComment,
                                            );
                                            self::render_field( 'toggle', $posts_comment_args );

                                            /**
                                             * toggle field for posts excerpt
                                             */
                                            $posts_excerpt_args = array(
                                                'title'     => __( 'Show posts excerpt', 'news-express' ),
                                                'name'      => 'postExcerpt',
                                                'value'     => $control->postExcerpt,
                                            );
                                            self::render_field( 'toggle', $posts_excerpt_args );

                                            /**
                                             * toggle field for posts more
                                             */
                                            $posts_more_args = array(
                                                'title'     => __( 'Show posts more', 'news-express' ),
                                                'name'      => 'postMore',
                                                'value'     => $control->postMore,
                                            );
                                            self::render_field( 'toggle', $posts_more_args );
                                        ?>

                                        <div class="action-buttons news-list">
                                            <div class="close-block"><?php esc_html_e( 'Close', 'news-express' ); ?></div>
                                            <div class="red-button remove-block"><?php esc_html_e( 'Remove', 'news-express' ); ?></div>
                                        </div><!-- .action-buttons -->

                                    </div><!-- .block-content-wrap -->

                                </div><!-- .news-list-block-wrap -->
                        <?php
                                break;

                            default : esc_html_e( 'No block defined ', 'news-express' );
                        }
                    endforeach;
                ?>
                <div class="button clone-block"><?php esc_html_e( 'Clone Block', 'news-express' ); ?></div>
            </div><!-- .blocks-repeater-control-wrap -->

            <input type="hidden" <?php esc_attr( $this->link() ); ?> class="blocks-repeater-control" value="<?php echo esc_attr( $this->value() ); ?>" />
            <input type="hidden" name="<?php echo esc_attr( $repeater_id ).'_count'; ?>" class="field-count" value="<?php echo absint( $field_count ); ?>">
            <input type="hidden" name="field_limit" class="field-limit" value="<?php echo esc_attr( $this->news_express_field_limit ); ?>">

    <?php
        } // end function render_content

        public function render_field( $type, $field_args = array() ) {
            switch ( $type ) {

                case 'text' :
    ?>
                    <div class="customize-text-field">
                        <label><?php echo esc_html( $field_args['title'] ); ?></label>
                        <p class="description"><?php echo esc_html( $field_args['description'] ); ?></p>
                        <input type="text" class="block-repeater-control-field" data-name="<?php echo esc_attr( $field_args['name'] ); ?>" value="<?php echo esc_attr( $field_args['value'] ); ?>"/>
                    </div><!-- .customize-text-field -->
    <?php
                    break;

                case 'url' :
    ?>
                    <div class="customize-url-field">
                        <label><?php echo esc_html( $field_args['title'] ); ?></label>
                        <input type="url" class="block-repeater-control-field" data-name="<?php echo esc_attr( $field_args['name'] ); ?>" value="<?php echo esc_url( $field_args['value'] ); ?>"/>
                    </div><!-- .customize-url-field -->
    <?php
                    break;

                case 'number' :
    ?>
                    <div class="customize-number-field">
                        <label><?php echo esc_html( $field_args['title'] ); ?></label>
                        <input type="number" min="<?php echo absint( $field_args['input_attrs']['min'] ); ?>" max="<?php echo absint( $field_args['input_attrs']['max'] ); ?>" step="<?php echo absint( $field_args['input_attrs']['step'] ); ?>" class="block-repeater-control-field" data-name="<?php echo esc_attr( $field_args['name'] ); ?>" value="<?php echo absint( $field_args['value'] ); ?>"/>
                    </div><!-- .customize-number-field -->
    <?php
                    break;
                    
                case 'toggle' :
    ?>
                    <div class="customize-toggle-field">
                        <div class="block-repeater-toggle">
                            <div class="toggle-wrapper">
                                <span class="toggle-title"><?php echo esc_html( $field_args['title'] ); ?></span>
                                <input type="checkbox" class="block-repeater-control-field" data-name="<?php echo esc_attr( $field_args['name'] ); ?>" <?php checked( true, $field_args['value'] ); ?> >
                                <label class="toggle-label"></label>
                            </div><!-- .toggle-wrapper -->
                        </div><!-- .block-repeater-toggle -->
                    </div><!-- .customize-toggle-field -->
    <?php
                    break;

                case 'select' :
    ?>
                    <div class="customize-select-field select-<?php echo esc_attr( $field_args['name'] ); ?>">
                        <label><?php echo esc_html( $field_args['title'] ); ?></label>
                        <select class="block-repeater-control-field" data-name="<?php echo esc_attr( $field_args['name'] ); ?>">
                            <?php
                                foreach ( $field_args['options'] as $key => $value ) {
                                    echo '<option value="'. esc_attr( $key ) .'" '. selected( $key, $field_args['value'] ) .'>'. esc_html( $value ) .'</option>';
                                }
                            ?>
                        </select>
                    </div><!-- .customize-select-field .select-<?php echo esc_attr( $field_args['name'] ); ?> -->
    <?php
                    break;

                case 'category_dropdown' :

                    $dropdown_categories = wp_dropdown_categories(
                        array(
                            'name'              => 'block-category',
                            'echo'              => 0,
                            'show_option_none'  => esc_html__( 'Latest Posts', 'news-express' ),
                            'value_field'       => 'slug',
                            'option_none_value' => 'all',
                            'selected'          => esc_attr( $field_args['value'] ),
                            'show_count'        => 1,
                            'hierarchical'      => 1,
                            'hide_empty'        => 1
                        )
                    );

                    $replace_select = '<select class="block-repeater-control-field" data-name="'. esc_attr( $field_args['name'] ) .'"';

                    // Hackily add in the data link parameter.
                    $dropdown_categories = str_replace( '<select', $replace_select, $dropdown_categories );
    ?>
                    <div class="customize-select-field select-category">
                        <label><?php echo esc_html( $field_args['title'] ); ?></label>
                        <?php echo $dropdown_categories; ?>
                    </div><!-- .customize-select-field .select-category -->
    <?php
                    break;

                case 'selector':
    ?>
                    <div class="customize-radio-image-field">
                        <label><?php echo esc_html( $field_args['title'] ); ?></label>
                        <p class="description"><?php echo esc_html( $field_args['description'] ); ?></p>
                        <?php
                            foreach( $field_args['choices'] as $layout_key => $layout ) :
                        ?>
                                <label class="radio-image-single <?php if ( $layout_key === $field_args['value'] ) echo 'selected'; ?>" data-value="<?php echo esc_attr( $layout_key ); ?>">
                                    <img src="<?php echo esc_url( $layout['img'] ); ?>"/>
                                    <span class="lbl-tooltip"><?php echo esc_html( $layout['label'] ); ?></span>
                                </label>
                        <?php
                            endforeach;
                        ?>
                        <input type="hidden" class="block-repeater-control-field" data-name="<?php echo esc_attr( $field_args['name'] ); ?>" value="<?php echo esc_attr( $field_args['value'] ); ?>"/>
                    </div><!-- .customize-radio-image-field -->
    <?php
                    break;

                case 'upload' :
    ?>
                    <div class="customize-upload-image-field">
                        <?php
                            $image_html = $image_class = "";
                            if ( ! empty( $field_args['value'] ) ) {
                                $image_html = '<img src="'.esc_url( $field_args['value'] ).'" style="max-width:100%;"/>';
                                $image_class = ' hidden';
                            }
                        ?>
                        <label><?php echo esc_html( $field_args['title'] ); ?></label>
                        <div class="placeholder<?php echo esc_attr( $image_class ); ?>"><?php esc_html_e( 'No image selected', 'news-express' ); ?></div>
                        <div class="field-thumbnail thumbnail-image"><?php echo $image_html; ?></div>
                        <div class="upload-actions clearfix">
                            <button type="button" class="news-express-button img-delete-button align-left">
                                <?php esc_html_e( 'Remove', 'news-express' ); ?>
                            </button>
                            <button type="button" class="news-express-button img-upload-button alignright">
                                <?php esc_html_e( 'Select Image', 'news-express' ); ?>
                            </button>
                        </div><!-- .upload-actions -->
                        <input type="hidden" class="block-repeater-control-field" data-name="<?php echo esc_attr( $field_args['name'] ); ?>" value="<?php echo esc_url( $field_args['value'] ); ?>">
                    </div><!-- .customize-upload-image-field -->
    <?php
                    break;

                case 'field_group_start';
                    echo '<div class="field-group-wrapper">';
                    break;

                case 'field_group_end';
                    echo '</div><!-- .field-group-wrapper --></div><!-- .group-toggle-wrapper -->';
                    break;

                case 'group_title';
                    echo '<div class="group-toggle-wrapper"><div class="block-query-group"><label>'. esc_html( $field_args['title'] ) .'</label><span class="group-trigger dashicons dashicons-edit"></span></div><!-- .block-query-group -->';
                    break;
                
                default:
                    // code...
                    break;
            }
        }
    }

endif;