( function( $ ) {
    // Function to evaluate conditions
    function evaluateCondition( value1, operator, value2 ) {
        switch ( operator ) {
            case '==': return value1 == value2;
            case '!=': return value1 != value2;
            case '>': return value1 > value2;
            case '<': return value1 < value2;
            case '>=': return value1 >= value2;
            case '<=': return value1 <= value2;
            default: return false;
        }
    }

    // Function to check and control visibility
    function controlVisibility( control, conditions ) {
        var visible = true;

        // Loop through each condition
        conditions.forEach( function( condition ) {
            var dependentControl = wp.customize.control( condition.control );
            if ( dependentControl ) {
                var controlValue = wp.customize( condition.control )();
                var requiredValue = condition.value;
                var operator = condition.operator || '==';

                if ( !evaluateCondition( controlValue, operator, requiredValue ) ) {
                    visible = false;
                }
            } else {
                visible = false;
            }
        });

        // Toggle visibility
        var $control = $( '#customize-control-' + control.id );
        if ( visible ) {
            $control.slideDown();
        } else {
            $control.slideUp();
        }
    }

    // Initialize dependencies
    function initDependencies() {
        wp.customize.control.each( function( control ) {
            //console.log( 'each control:', control ); // Debugging
            if ( control.params.required ) {
                var conditions = control.params.required;

                //console.log( 'Dependency found for:', control.id, conditions ); // Debugging

                // Initial check
                controlVisibility( control, conditions );

                // Bind to changes in each required control
                conditions.forEach( function( condition ) {
                    wp.customize( condition.control, function( setting ) {
                        setting.bind( function() {
                            controlVisibility( control, conditions );
                        });
                    });
                });
            }
        });
    }

    // Initialize on document ready
    $/*( document ).ready( function() {
        initDependencies();*/
    // Run when Customizer is ready
    wp.customize.bind('ready', function () {
        initDependencies();

    });

})( jQuery );
