<?php
/**
 * Managed the custom functions and hooks for entire theme.
 *
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}


/*------------------------------ Header Section -------------------------*/

    if ( ! function_exists( 'news_express_custom_header_html' ) ) :

        /**
         * function to get custom header markup
         * 
         * @since 1.0.0
         */
        function news_express_custom_header_html() {
            the_custom_header_markup();
        }

    endif;

    add_action( 'news_express_header_section', 'news_express_custom_header_html', 10 );

    if ( ! function_exists( 'news_express_header' ) ) :

        /**
         * function to display the header section at header area.
         * 
         * @since 1.0.0
         */
        function news_express_header() {
            get_template_part( 'template-parts/header/header', 'header' );
        }

    endif;

    add_action( 'news_express_header_section', 'news_express_header', 20 );

    if(!function_exists('header_news_ticker_section')):
        /**
         * function to display news ticker
         * 
         * @since 1.0.0
         */
        function header_news_ticker_section(){
            if (! is_home() && !is_front_page()){
                return;
            }
            get_template_part( 'template-parts/header/news', 'ticker' );
        }

    endif;
      add_action('news_express_header_section', 'header_news_ticker_section', 30);

/*------------------------------ Frontpage Banner Section --------------------*/

    if ( ! function_exists( 'news_express_frontpage_main_banner' ) ) :

        /**
         * function to display the main banner section at front page.
         * 
         * @since 1.0.0
         */
        function news_express_frontpage_main_banner() {
            get_template_part( 'template-parts/frontpage/main', 'banner' );
        }

    endif;

    add_action( 'news_express_frontpage_section', 'news_express_frontpage_main_banner', 10 );

/*------------------------------ Advertisement Section --------------------*/

    if ( ! function_exists( 'news_express_advertisement' ) ) :

        /**
         * function to display the main banner section at front page.
         * 
         * @since 1.0.0
         */
        function news_express_advertisement() {
            get_template_part( 'template-parts/frontpage/advertisement' );
        }

    endif;

    add_action( 'news_express_frontpage_section', 'news_express_advertisement', 20 );


/*------------------------------ Frontpage Middle Content Section ------------*/
    
    if ( ! function_exists( 'news_express_frontpage_middle_content' ) ) :

        /**
         * function to display the middle content section at front page.
         * 
         * @since 1.0.0
         */
        function news_express_frontpage_middle_content() {
            get_template_part( 'template-parts/frontpage/middle', 'content' );
        }

    endif;

    add_action( 'news_express_frontpage_section', 'news_express_frontpage_middle_content', 30 );


 /*------------------------------ Frontpage Bottom Fullwidth Section ----------*/
    
    if ( ! function_exists( 'news_express_frontpage_bottom_fullwidth' ) ) :

        /**
         * function to display the bottom fullwidth section at front page.
         * 
         * @since 1.0.0
         */
        function news_express_frontpage_bottom_fullwidth() {
            get_template_part( 'template-parts/frontpage/bottom', 'fullwidth' );
        }

    endif;

    add_action( 'news_express_frontpage_section', 'news_express_frontpage_bottom_fullwidth', 40 );

/*-------------------- Innerpage Archive Pages ---------------------*/

 if ( ! function_exists( 'news_express_post_author_box' ) ) :

        /**
         * function to display the author box section in single post page.
         * 
         * @since 1.0.0
         */
        function news_express_post_author_box() {
            get_template_part( 'template-parts/partials/post/author', 'box' );
        }

    endif;

    add_action( 'news_express_after_single_post_loop_content', 'news_express_post_author_box', 10 );

    if ( ! function_exists( 'news_express_single_post_related_posts_section' ) ) :

        /**
         * function to display the related posts sections in single post page.
         * 
         * @since 1.0.0
         */
        function news_express_single_post_related_posts_section() {
            get_template_part( 'template-parts/partials/post/related', 'posts' );
        }

    endif;

    add_action( 'news_express_after_single_post_loop_content', 'news_express_single_post_related_posts_section', 20 );


    if ( ! function_exists( 'news_express_archive_title_prefix' ) ) :
        
        /**
         * Archive title prefix
         *
         * @since 1.0.0
         */
        function news_express_archive_title_prefix( $title ) {

            $title_prefix_enable = news_express_get_customizer_option_value( 'news_express_archive_title_prefix_enable' );

            if ( false === $title_prefix_enable ) {
                return preg_replace( '/^\w+: /', '', $title );
            } else {
                return $title;
            }
            
        }

    endif;

    add_filter( 'get_the_archive_title', 'news_express_archive_title_prefix' );

    /*------------------------------ Footer Section ------------------------------*/

    if ( ! function_exists( 'news_express_scroll_top_section' ) ) :

        /**
         * function to display the scroll top section in footer.
         * 
         * @since 1.0.0
         */
        function news_express_scroll_top_section() {
            get_template_part( 'template-parts/footer/scroll', 'top' );
        }

    endif;

    add_action( 'news_express_after_page', 'news_express_scroll_top_section', 10 );