/**
 * Get Started button on dashboard notice.
 *
 * @package News Express
 */

jQuery(document).ready(function($) {
    var WpAjaxurl       = neAdminObject.ajax_url;
    var _wpnonce        = neAdminObject._wpnonce;
    var buttonStatus    = neAdminObject.buttonStatus;

    /**
     * Popup on click demo import if mysterythemes demo importer plugin is not activated.
     */
    if( buttonStatus === 'disable' ) $( '.news-express-demo-import' ).addClass( 'disabled' );

    switch( buttonStatus ) {
        case 'activate' :
            $( '.news-express-get-started' ).on( 'click', function() {
                var _this = $( this );
                news_express_do_plugin( 'news_express_activate_plugin', _this );
            });
            $( '.news-express-activate-demo-import-plugin' ).on( 'click', function() {
                var _this = $( this );
                news_express_do_plugin( 'news_express_activate_plugin', _this );
            });
            break;
        case 'install' :
            $( '.news-express-get-started' ).on( 'click', function() {
                var _this = $( this );
                news_express_do_plugin( 'news_express_install_plugin', _this );
            });
            $( '.news-express-install-demo-import-plugin' ).on( 'click', function() {
                var _this = $( this );
                news_express_do_plugin( 'news_express_install_plugin', _this );
            });
            break;
        case 'redirect' :
            $( '.news-express-get-started' ).on( 'click', function() {
                var _this = $( this );
                location.href = _this.data( 'redirect' );
            });
            break;
    }
    
    news_express_do_plugin = function ( ajax_action, _this ) {
        $.ajax({
            method : "POST",
            url : WpAjaxurl,
            data : ({
                'action' : ajax_action,
                '_wpnonce' : _wpnonce
            }),
            beforeSend: function() {
                var loadingTxt = _this.data( 'process' );
                _this.addClass( 'updating-message' ).text( loadingTxt );
            },
            success: function( response ) {
                if( response.success ) {
                    var loadedTxt = _this.data( 'done' );
                    _this.removeClass( 'updating-message' ).text( loadedTxt );
                }
                location.href = _this.data( 'redirect' );
            }
        });
    }

    $('.mt-action-btn').click(function(){
        var _this = $(this), actionBtnStatus = _this.data('status'), pluginSlug = _this.data('slug');
        console.log(actionBtnStatus);
        switch(actionBtnStatus){
            case 'install':
                news_express_do_free_plugin( 'news_express_install_free_plugin', pluginSlug, _this );
                break;

            case 'active':
                news_express_do_free_plugin( 'news_express_activate_free_plugin', pluginSlug, _this );
                break;
        }

    });

    news_express_do_free_plugin = function ( ajax_action, pluginSlug, _this ) {
        $.ajax({
            method : "POST",
            url : WpAjaxurl,
            data : ({
                'action' : ajax_action,
                'plugin_slug': pluginSlug,
                '_wpnonce' : _wpnonce
            }),
            beforeSend: function() {
                var loadingTxt = _this.data( 'process' );
                _this.addClass( 'updating-message' ).text( loadingTxt );
            },
            success: function( response ) {
                if( response.success ) {
                    var loadedTxt = _this.data( 'done' );
                    _this.removeClass( 'updating-message' ).text( loadedTxt );
                }
                location.href = _this.data( 'redirect' );
            }
        });
    }

});