<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> <?php news_express_schema_markup( 'html' ); ?>>
<?php
	wp_body_open();

	/**
	 * hook - news_express_before_page
	 *
	 * @since 1.0.0
	 */
	do_action( 'news_express_before_page' );
?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'news-express' ); ?></a>

	<?php
		/**
		 * hook - news_express_header_section
		 *
		 * @hooked - news_express_custom_header_html - 10
		 * @hooked - news_express_top_header - 20
		 * @hooked - news_express_main_header - 30
		 * @hooked - header_ads_section - 40
		 *
		 * @since 1.0.0
		 */
		do_action( 'news_express_header_section' );
	?>

	<div id="content" class="site-content" <?php news_express_schema_markup( 'creative_work' ); ?>>

		<?php

			if ( is_home() && is_front_page() ) {

				/**
				 * hook - news_express_frontpage_section
				 *
				 * @hooked - news_express_frontpage_main_banner - 10
				 * @hooked - news_express_frontpage_middle_content - 30
				 *
				 * @since 1.0.0
				 */
				do_action( 'news_express_frontpage_section' );

			}

		?>
