<?php
/**
 * The template for displaying the footer
 * 
 * @package News Express
 * 
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
    </div><!-- #content -->

    <?php do_action( 'news_express_before_colophon' ); ?>

    <?php
    // Check if either footer section is enabled before rendering <footer>
    $footer_main_enabled   = news_express_get_customizer_option_value( 'news_express_footer_main_enable' );
    $footer_bottom_enabled = news_express_get_customizer_option_value( 'news_express_footer_bottom_enable' );

    if ( $footer_main_enabled || $footer_bottom_enabled ) : ?>
        <footer id="colophon" class="site-footer" <?php news_express_schema_markup( 'footer' ); ?>>
            <?php
                if ( $footer_main_enabled ) {
                    get_template_part( 'template-parts/partials/footer/widget', 'area' );
                }

                if ( $footer_bottom_enabled ) {
                    get_template_part( 'template-parts/footer/bottom', 'area' );
                }
            ?>
        </footer><!-- #colophon -->
    <?php endif; ?>

    <?php do_action( 'news_express_after_colophon' ); ?>
</div><!-- #page -->

<?php
    do_action( 'news_express_after_page' );
    wp_footer();
?>

</body>
</html>
