<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package News Express
 */

get_header();
?>
	<div class="news-express-container">
		<main id="primary" class="site-main">		
		<section class="error-404 not-found">
			<section class="error-container">
				<span>4</span>
				<span><span class="screen-reader-text">0</span></span>
				<span>4</span>
			</section><!-- .error-container -->
			<header class="page-header">
				<h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'news-express' ); ?></h1>
			</header><!-- .page-header -->
			<div class="page-content">
				<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'news-express' ); ?></p>

					<?php
					get_search_form();?>

			</div><!-- .page-content -->
		</section><!-- .error-404 -->

	</main><!-- #main -->
	</div> <!-- news-express-container -->

<?php
	/**
	 * hook - news_express_after_page_post_content
	 *
	 * @since 1.0.0
	 */
	do_action( 'news_express_after_page_post_content' );

	get_footer();
