<?php
/**
 * News Filter template one
 * 
 * @package News Event
 * @since 1.0.0
 */
extract( $args );
$filter_query = json_decode( $options->query );
$postCategories = ( isset( $filter_query->categories ) && ! empty( $filter_query->categories ) ) ? news_event_get_categories_for_args( $filter_query->categories ) : '';
$postCategories = explode( ",", $postCategories );
array_unshift( $postCategories, 'All' );

$view_allclass = 'viewall_disabled';
if( $options->viewallLabelOption ){
    $view_allclass = 'viewall_enabled';
}
$block_id_attribute = ( $options->blockId ) ? ( ' ' . $options->blockId ) : '';
?>
<div id="<?php echo esc_attr( $uniqueID . $block_id_attribute ); ?>" class="news-filter news-event-block news-event-mobile-burger <?php echo esc_attr( 'layout--' . $options->layout );?>" data-args="<?php echo esc_attr( json_encode( $options ) ); ?>">
    <div class="news-filter-post-wrap <?php echo esc_attr($view_allclass); ?>">
        <div class="post_title_filter_wrap">
            <?php 
                do_action( 'news_event_section_block_view_all_hook', array(
                    'option'=> isset( $options->viewallLabelOption ) ? $options->viewallLabelOption : false,
                    'classes' => 'view-all-button',
                    'link'  => isset( $options->viewallUrl ) ? $options->viewallUrl : '',
                    'text_option'  => isset( $options->viewallLabelOption ) ? $options->viewallLabelOption : false,
                    'text'  => isset( $options->viewallLabel ) ? $options->viewallLabel : esc_html__( 'View all', 'news-event' )
                ));
                
                if( $options->title ) : ?>
                    <h2 class="news-event-block-title">
                        <span><?php echo esc_html( $options->title ); ?></span>
                    </h2>
            <?php endif; ?>
            <?php 
            if( $postCategories ) : ?>
                <div class="filter-tab-wrapper">
                    <div class="tab-burger-wrap">
                        <div class="title-tab-wrap">
                            <?php
                                foreach( $postCategories as $postCat => $postCatVal ) :
                                    $category_name = get_cat_name( absint( $postCatVal ) ) ? get_cat_name( absint( $postCatVal ) ) : $postCatVal;
                                        if( $category_name ) :
                                            ?>
                                            <div class="tab-title<?php if( $postCat < 1 ) echo esc_attr( ' isActive' ); ?>" data-tab="<?php echo ( $postCat > 0 ) ? esc_attr( $postCatVal ) : 'news-event-filter-all'; ?>"><?php echo esc_html( $category_name ); ?></div>
                                        <?php
                                    endif;
                                endforeach;
                            ?>
                        </div>
                        <span class="news-event-burger">
                            <i class="fa-solid fa-ellipsis-vertical"></i>
                        </span>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php
        if( $postCategories ) :
        ?>
            <div class="filter-tab-content-wrapper">
                <div class="tab-content content-news-event-filter-all">
                    <?php
                        unset( $post_args['category_name'] );
                        $post_query = new WP_Query( $post_args );
                        $options->featuredPosts = false;
                        if( $post_query->have_posts() ) :
                            $delay =0;
                            while( $post_query->have_posts() ) : 
                                $post_query->the_post();
                                $options->delay = $delay;
                                get_template_part( 'template-parts/news-filter/content', 'one', $options );
                                $delay += 50;
                            endwhile;
                        endif;
                    ?>
                </div>
            </div>
            <?php
        endif;
        ?>
    </div>
</div>