<?php
/**
 * News Filter template two
 * 
 * @package News Event
 * @since 1.0.0
 */
extract( $args );
$filter_query = json_decode( $options->query );
$postCategories = ( isset( $filter_query->categories ) && ! empty( $filter_query->categories ) ) ? news_event_get_categories_for_args( $filter_query->categories ) : '';
$postCategories = explode( ",", $postCategories );
array_unshift( $postCategories, 'All' );

$view_allclass = 'viewall_disabled';
if( $options->viewallLabelOption ){
    $view_allclass = 'viewall_enabled';
}
$block_id_attribute = ( $options->blockId ) ? ( ' ' . $options->blockId ) : '';
?>
<div id="<?php echo esc_attr( $uniqueID . $block_id_attribute ); ?>" class="news-alter news-event-block <?php echo esc_attr( 'layout--' . $options->layout );?>" data-args="<?php echo esc_attr( json_encode( $options ) ); ?>">
    <div class="news-alter-post-wrap <?php echo esc_attr($view_allclass); ?>">
        <?php 
            do_action( 'news_event_section_block_view_all_hook', array(
                'option'=> isset( $options->viewallLabelOption ) ? $options->viewallLabelOption : false,
                'classes' => 'view-all-button',
                'link'  => isset( $options->viewallUrl ) ? $options->viewallUrl : '',
                'text_option'  => isset( $options->viewallLabelOption ) ? $options->viewallLabelOption : false,
                'text'  => isset( $options->viewallLabel ) ? $options->viewallLabel : esc_html__( 'View all', 'news-event' )
            ));
            
            if( $options->title ) : ?>
                <h2 class="news-event-block-title">
                    <span><?php echo esc_html( $options->title ); ?></span>
                </h2>
        <?php endif;
        if( $postCategories ) :
        ?>
        <div class="news-alter-content-wrapper">
            <?php
                if( array_key_exists( 'category_name', $post_args ) ) $post_args['cat'] = $post_args['category_name'];
                unset( $post_args['category_name'] );
                $post_query = new WP_Query( $post_args );
                $total_posts = $post_query->post_count;
                if( $post_query->have_posts() ) :
                    $delay = 0;
                    $row_count = 0;
                    while( $post_query->have_posts() ) : $post_query->the_post();
                        $current_post = $post_query->current_post;
                        $last_item = ( $total_posts === ( $current_post + 1 ) );
                        $options->featuredPosts = false;
                        if( ($current_post % 5) === 0 && $row_count < 2 ) {
                            echo '<div class="row-wrap">';
                            $row_count++;
                        }
                            if( $current_post === 0 ) {
                                echo '<div class="featured-post">';
                                $options->featuredPosts = true;
                            }
                                if( $current_post === 1 || $current_post === 5 ) {
                                    ?>
                                    <div class="trailing-post <?php if($current_post === 5) echo esc_attr('bottom-trailing-post'); ?>">
                                    <?php
                                }
                                    if( $current_post === 1 ) echo '<div class="grid-posts">';
                                    if( $current_post === 3 ) echo '<div class="list-posts">';
                                    $options->delay = $delay;
                                    // get template file w.r.t par
                                        get_template_part( 'template-parts/news-alter/content', 'one', $options );
                                    if( $current_post === 2 || ( $last_item && $total_posts <= 3 && $total_posts >= 2 ) ) echo '</div><!-- .grid-posts -->';
                                    if( $current_post === 4 || ( $last_item && $total_posts <= 5 && $total_posts >= 4 ) ) echo '</div><!-- .list-posts -->';
                                if( $current_post === 4 || $last_item ) echo '</div><!-- .trailing-post -->';
                            if( $current_post === 0 ) echo '</div><!-- .featured-post-->';
                            if( ! in_array( $current_post, [ 0, 4 ] ) && $last_item ) echo '</div><!-- .total-posts-close -->';
                        if( $row_count <= 2 && $current_post === 4 ) echo '</div><!-- .row-wrap -->';
                        $delay += 50;
                    endwhile;
                endif;
            ?>
        </div>
        <?php
        endif;
        ?>
    </div>
</div>