<?php
/**
 * Template part for displaying block content in alter block
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News Event
 */
use NewsEvent\CustomizerDefault as NEV;
?>
<article class="alter-item<?php if(!has_post_thumbnail()) { echo esc_attr(' no-feat-img');} ?>">
    <div class="blaze_box_wrap news-event-card">
        <figure class="post-thumb-wrap">
            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                <?php
                    if( has_post_thumbnail() ) { 
                        the_post_thumbnail($args->imageSize, array(
                            'title' => the_title_attribute(array(
                                'echo'  => false
                            )),
                            'loading' => 'lazy'
                        ));
                    }
                ?>
            </a>
            <?php if( $args->categoryOption && $args->featuredPosts ) news_event_get_post_categories( get_the_ID(), 2 ); ?>
        </figure>
        <div class="post-element">
            <h2 class="post-title"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
            <div class="post-meta">
                <?php
                    if( $args->authorOption ) news_event_posted_by();
                    if( $args->dateOption ) news_event_posted_on();
                    if( $args->commentOption ) echo '<span class="post-comment far fa-comment">', absint( get_comments_number() ), '</span>';
                ?>
            </div>
            
            <?php
                if( $args->excerptOption ):
                    $excerptLength = isset( $options->excerptLength ) ? $options->excerptLength: 10; 
                    echo '<div class="post-excerpt">' .esc_html( wp_trim_words( wp_strip_all_tags( get_the_excerpt() ), $args->excerptLength ) ). '</div>';
                endif;
                do_action( 'news_event_section_block_view_all_hook', array(
                    'option'    => isset( $args->buttonOption ) ? $args->buttonOption : false
                ));
            ?>
        </div>
    </div>
</article>