<?php
/**
 * Main Banner template Seven
 * 
 * @package News Event
 * @since 1.0.0
 */
use NewsEvent\CustomizerDefault as NEV;
$main_banner_block_posts_to_include = NEV\news_event_get_customizer_option( 'main_banner_block_posts_to_include' );
$main_banner_block_posts_categories = NEV\news_event_get_customizer_option( 'main_banner_block_posts_categories' );
$main_banner_block_posts_order_by = NEV\news_event_get_customizer_option( 'main_banner_block_posts_order_by' );
$main_banner_block_posts_categories_option = NEV\news_event_get_customizer_option( 'main_banner_block_posts_categories_option' );
$main_banner_block_posts_date_option = NEV\news_event_get_customizer_option( 'main_banner_block_posts_date_option' );
$blockPostsOrderArray = explode( '-', $main_banner_block_posts_order_by );
$block_posts_args = array(
    'numberposts'   =>  6,
    'order' =>  esc_html( $blockPostsOrderArray[1] ),
    'orderby'   =>  esc_html( $blockPostsOrderArray[0] ),
    'cat'   =>  news_event_get_categories_for_args($main_banner_block_posts_categories),
    'fields'    =>  'ids'
);
if( ! empty( $main_banner_block_posts_to_include ) ) $block_posts_args['post__in'] = news_event_get_post_id_for_args( $main_banner_block_posts_to_include ); 
$total_posts = get_posts( $block_posts_args );
$block_posts = array_slice( $total_posts, 0, 6 );
$trailing_posts = array_slice( $total_posts, 6 );
?>
    <div class="main-banner-wrap">
        <?php
            if( $block_posts ) :
                foreach( $block_posts as $index => $popular_post_id ) :
                    $blockWrapClass = 'block-wrap';
                    if( $index === 0 ) $blockWrapClass .= ' first';
                    if( $index === 3 ) $blockWrapClass .= ' second';
                    if( in_array( $index, [ 0, 3 ] ) ) echo '<div class="', esc_attr( $blockWrapClass ), '">';
                        ?>
                            <article class="post-item news-event-card<?php if(!has_post_thumbnail($popular_post_id)){ echo esc_attr(' no-feat-img');} ?>">
                                <figure class="post-thumb">
                                    <?php if( has_post_thumbnail($popular_post_id) ): ?>
                                        <a href="<?php echo esc_url(get_the_permalink($popular_post_id)); ?>" title="<?php the_title_attribute(['post' => $popular_post_id]); ?>">
                                            <img src="<?php echo esc_url( get_the_post_thumbnail_url($popular_post_id, 'news-event-featured') ); ?>" alt="<?php echo esc_attr( get_post_meta( get_post_thumbnail_id($popular_post_id), '_wp_attachment_image_alt', true ) ); ?>" loading="lazy"/>
                                        </a>
                                    <?php endif; ?>
                                </figure>
                                <div class="post-element">
                                    <?php if( $main_banner_block_posts_categories_option ) : ?>
                                            <div class="post-meta">
                                                <?php news_event_get_post_categories( $popular_post_id, 2 ); ?>
                                            </div>
                                    <?php endif; ?>
                                    <h2 class="post-title"><a href="<?php the_permalink($popular_post_id); ?>"><?php echo wp_kses_post( get_the_title($popular_post_id) ); ?></a></h2>
                                    <?php if( in_array( $index, [ 0, 5 ] ) && $main_banner_block_posts_date_option ) news_event_posted_on( $popular_post_id ); ?>
                                </div>
                            </article>
                        <?php
                    if( in_array( $index, [ 2, 5 ] ) ) echo '</div>';
                endforeach;
            endif;
        ?>
    </div>
<?php
    if( $trailing_posts ) :
        echo '<div class="block-wrap">';
            foreach( $trailing_posts as $index => $popular_post_id ) :
                $blockWrapClass = 'block-wrap';
                ?>
                    <article class="post-item news-event-card<?php if(!has_post_thumbnail($popular_post_id)){ echo esc_attr(' no-feat-img');} ?>">
                        <figure class="post-thumb">
                            <?php if( has_post_thumbnail($popular_post_id) ): ?>
                                <a href="<?php echo esc_url(get_the_permalink($popular_post_id)); ?>" title="<?php the_title_attribute(['post' => $popular_post_id]); ?>">
                                    <img src="<?php echo esc_url( get_the_post_thumbnail_url($popular_post_id, 'news-event-featured') ); ?>" alt="<?php echo esc_attr( get_post_meta( get_post_thumbnail_id($popular_post_id), '_wp_attachment_image_alt', true ) ); ?>" loading="lazy"/>
                                </a>
                            <?php endif; ?>
                        </figure>
                        <div class="post-element">
                            <?php if( $main_banner_block_posts_categories_option ) : ?>
                                    <div class="post-meta">
                                        <?php news_event_get_post_categories( $popular_post_id, 2 ); ?>
                                    </div>
                            <?php endif; ?>
                            <h2 class="post-title"><a href="<?php the_permalink($popular_post_id); ?>"><?php echo wp_kses_post( get_the_title($popular_post_id) ); ?></a></h2>
                        </div>
                    </article>
                <?php
            endforeach;
        echo '</div>';
    endif;