<?php
/**
 * Adds News_Event_Posts_Grid_Two_Column_Widget widget.
 * 
 * @package News Event
 * @since 1.0.0
 */
class News_Event_Posts_Grid_Two_Column_Widget extends WP_Widget {
    /**
     * Register widget with WordPress.
     */
    public function __construct() {
        parent::__construct(
            'news_event_posts_grid_two_column_widget',
            esc_html__( 'News Event : Posts Grid 2 Column', 'news-event' ),
            array( 'description' => __( 'A collection of posts from specific category displayed in grid two column layout.', 'news-event' ) )
        );
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        extract( $args );
        $widget_title = isset( $instance['widget_title'] ) ? $instance['widget_title'] : '';
        $posts_category = isset( $instance['posts_category'] ) ? $instance['posts_category'] : '';
        $posts_count = 6;
        $widget_layout = isset( $instance['widget_layout'] ) ? $instance['widget_layout'] : 'layout-one';
        echo wp_kses_post($before_widget);
            if ( ! empty( $widget_title ) ) echo $before_title . $widget_title . $after_title;
            $elementClass = 'posts-wrap posts-grid-two-column-wrap feature-post-block';
            $elementClass .= ' ' . $widget_layout;
    ?>
            <div class="<?php echo esc_attr( $elementClass ); ?>">
                <?php
                    $post = new WP_Query( 
                        array( 
                            'cat'    => absint( $posts_category ),
                            'posts_per_page' => absint( $posts_count ),
                            'ignore_sticky_posts'    => true
                        )
                    );
                    if( $post->have_posts() ) :
                        $delay = 0;
                        while( $post->have_posts() ) : $post->the_post();
                            $thumbnail_url = get_the_post_thumbnail_url( get_the_ID(), 'news-event-list' );
                            $categories = get_categories([ 'object_ids' => get_the_ID(), 'number' => 1 ]);
                    ?>
                        <div class="blaze_box_wrap">
                            <div class="post-item news-event-card format-standard <?php if( $widget_layout == 'layout-two'){ echo esc_attr('news-event-category-no-bk'); } ?>">
                                <div class="post_thumb_image post-thumb <?php if( !$thumbnail_url ) echo esc_attr('no-feat-img'); ?>">
                                    <figure class="post-thumb">
                                        <?php if( $thumbnail_url ) : ?>
                                            <a href="<?php the_permalink(); ?>">
                                                <img src="<?php echo esc_url( $thumbnail_url ); ?>" loading="<?php news_event_lazy_load_value(); ?>">
                                            </a>
                                        <?php endif; ?>
                                    </figure>
                                </div>
                                <div class="post-content-wrap card__content">
                                    <div class="news-event-post-title card__content-title post-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                        $delay += 50;
                        endwhile;
                        wp_reset_postdata();
                    endif;
                ?>
            </div>
            <?php
        echo wp_kses_post($after_widget);
    }

    /**
     * Widgets fields
     * 
     */
    function widget_fields() {
        $categories = get_categories();
        $categories_options[''] = esc_html__( 'Select category', 'news-event' );
        foreach( $categories as $category ) :
            $categories_options[$category->term_id] = $category->name. ' (' .$category->count. ') ';
        endforeach;
        return array(
                array(
                    'name'      => 'widget_title',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Widget Title', 'news-event' ),
                    'description'=> esc_html__( 'Add the widget title here', 'news-event' ),
                    'default'   => esc_html__( 'Latest News', 'news-event' )
                ),
                array(
                    'name'      => 'posts_category',
                    'type'      => 'select',
                    'title'     => esc_html__( 'Categories', 'news-event' ),
                    'description'=> esc_html__( 'Choose the category to display list of posts', 'news-event' ),
                    'options'   => $categories_options
                ),
                array(
                    'name'      => 'widget_layout',
                    'type'      => 'select',
                    'title'     => esc_html__( 'Layouts', 'news-event' ),
                    'options'   => array(
                        'layout-one'    => esc_html__( 'Layout One', 'news-event' ),
                        'layout-two'    => esc_html__( 'Layout Two', 'news-event' )
                    )
                )
            );
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ) {
        $widget_fields = $this->widget_fields();
        foreach( $widget_fields as $widget_field ) :
            if ( isset( $instance[ $widget_field['name'] ] ) ) {
                $field_value = $instance[ $widget_field['name'] ];
            } else if( isset( $widget_field['default'] ) ) {
                $field_value = $widget_field['default'];
            } else {
                $field_value = '';
            }
            news_event_widget_fields( $this, $widget_field, $field_value );
        endforeach;
    }
 
    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $widget_fields = $this->widget_fields();
        if( ! is_array( $widget_fields ) ) {
            return $instance;
        }
        foreach( $widget_fields as $widget_field ) :
            $instance[$widget_field['name']] = news_event_sanitize_widget_fields( $widget_field, $new_instance );
        endforeach;

        return $instance;
    }
 
} // class News_Event_Posts_Grid_Two_Column_Widget